/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.usage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.node.usage.NodeUsage;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;

public class UsageService
extends AbstractComponent {
    private final List<BaseRestHandler> handlers = new ArrayList<BaseRestHandler>();
    private final long sinceTime = System.currentTimeMillis();

    @Inject
    public UsageService(Settings settings) {
        super(settings);
    }

    public void addRestHandler(BaseRestHandler handler) {
        this.handlers.add(handler);
    }

    public NodeUsage getUsageStats(DiscoveryNode localNode, boolean restActions) {
        HashMap<String, Long> restUsageMap;
        if (restActions) {
            restUsageMap = new HashMap<String, Long>();
            this.handlers.forEach(handler -> {
                long usageCount = handler.getUsageCount();
                if (usageCount > 0L) {
                    restUsageMap.put(handler.getName(), usageCount);
                }
            });
        } else {
            restUsageMap = null;
        }
        return new NodeUsage(localNode, System.currentTimeMillis(), this.sinceTime, restUsageMap);
    }
}

