/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.StringFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.TermsSortedDocsProducer;

class BinaryValuesSource
extends SingleDimensionValuesSource<BytesRef> {
    private final CheckedFunction<LeafReaderContext, SortedBinaryDocValues, IOException> docValuesFunc;
    private final BytesRef[] values;
    private BytesRef currentValue;

    BinaryValuesSource(MappedFieldType fieldType, CheckedFunction<LeafReaderContext, SortedBinaryDocValues, IOException> docValuesFunc, DocValueFormat format, Object missing, int size, int reverseMul) {
        super(format, fieldType, missing, size, reverseMul);
        this.docValuesFunc = docValuesFunc;
        this.values = new BytesRef[size];
    }

    @Override
    public void copyCurrent(int slot) {
        this.values[slot] = BytesRef.deepCopyOf(this.currentValue);
    }

    @Override
    public int compare(int from, int to) {
        return this.compareValues(this.values[from], this.values[to]);
    }

    @Override
    int compareCurrent(int slot) {
        return this.compareValues(this.currentValue, this.values[slot]);
    }

    @Override
    int compareCurrentWithAfter() {
        return this.compareValues(this.currentValue, (BytesRef)this.afterValue);
    }

    int compareValues(BytesRef v1, BytesRef v2) {
        return v1.compareTo(v2) * this.reverseMul;
    }

    @Override
    void setAfter(Comparable<?> value) {
        if (value.getClass() != String.class) {
            throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
        }
        this.afterValue = this.format.parseBytesRef(value.toString());
    }

    @Override
    BytesRef toComparable(int slot) {
        return this.values[slot];
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedBinaryDocValues dvs = this.docValuesFunc.apply(context);
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        BinaryValuesSource.this.currentValue = dvs.nextValue();
                        next.collect(doc, bucket);
                    }
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable<?> value, LeafReaderContext context, final LeafBucketCollector next) {
        if (value.getClass() != BytesRef.class) {
            throw new IllegalArgumentException("Expected BytesRef, got " + value.getClass());
        }
        this.currentValue = (BytesRef)value;
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !(this.fieldType instanceof StringFieldType) || query != null && query.getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        return new TermsSortedDocsProducer(this.fieldType.name());
    }

    @Override
    public void close() {
    }
}

