/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActiveShardCount;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestShrinkIndexAction
extends BaseRestHandler {
    public RestShrinkIndexAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_shrink/{target}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_shrink/{target}", this);
    }

    @Override
    public String getName() {
        return "shrink_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ResizeRequest shrinkIndexRequest = new ResizeRequest(request.param("target"), request.param("index"));
        shrinkIndexRequest.setResizeType(ResizeType.SHRINK);
        request.applyContentParser(shrinkIndexRequest::fromXContent);
        shrinkIndexRequest.timeout(request.paramAsTime("timeout", shrinkIndexRequest.timeout()));
        shrinkIndexRequest.masterNodeTimeout(request.paramAsTime("master_timeout", shrinkIndexRequest.masterNodeTimeout()));
        shrinkIndexRequest.setWaitForActiveShards(ActiveShardCount.parseString(request.param("wait_for_active_shards")));
        return channel -> client.admin().indices().resizeIndex(shrinkIndexRequest, new RestToXContentListener<ResizeResponse>((RestChannel)channel));
    }
}

