/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.CompoundProcessor;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.ConfigurationUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.IngestDocument;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.Processor;

public final class Pipeline {
    static final String DESCRIPTION_KEY = "description";
    static final String PROCESSORS_KEY = "processors";
    static final String VERSION_KEY = "version";
    static final String ON_FAILURE_KEY = "on_failure";
    private final String id;
    @Nullable
    private final String description;
    @Nullable
    private final Integer version;
    private final CompoundProcessor compoundProcessor;

    public Pipeline(String id, @Nullable String description, @Nullable Integer version, CompoundProcessor compoundProcessor) {
        this.id = id;
        this.description = description;
        this.compoundProcessor = compoundProcessor;
        this.version = version;
    }

    public void execute(IngestDocument ingestDocument) throws Exception {
        this.compoundProcessor.execute(ingestDocument);
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public CompoundProcessor getCompoundProcessor() {
        return this.compoundProcessor;
    }

    public List<Processor> getProcessors() {
        return this.compoundProcessor.getProcessors();
    }

    public List<Processor> getOnFailureProcessors() {
        return this.compoundProcessor.getOnFailureProcessors();
    }

    public List<Processor> flattenAllProcessors() {
        return this.compoundProcessor.flattenProcessors();
    }

    public static final class Factory {
        public Pipeline create(String id, Map<String, Object> config, Map<String, Processor.Factory> processorFactories) throws Exception {
            String description = ConfigurationUtils.readOptionalStringProperty(null, null, config, Pipeline.DESCRIPTION_KEY);
            Integer version = ConfigurationUtils.readIntProperty(null, null, config, Pipeline.VERSION_KEY, null);
            List<Map<String, Map<String, Object>>> processorConfigs = ConfigurationUtils.readList(null, null, config, Pipeline.PROCESSORS_KEY);
            List<Processor> processors = ConfigurationUtils.readProcessorConfigs(processorConfigs, processorFactories);
            List<Map<String, Map<String, Object>>> onFailureProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, Pipeline.ON_FAILURE_KEY);
            List<Processor> onFailureProcessors = ConfigurationUtils.readProcessorConfigs(onFailureProcessorConfigs, processorFactories);
            if (!config.isEmpty()) {
                throw new ElasticsearchParseException("pipeline [" + id + "] doesn't support one or more provided configuration parameters " + Arrays.toString(config.keySet().toArray()), new Object[0]);
            }
            if (onFailureProcessorConfigs != null && onFailureProcessors.isEmpty()) {
                throw new ElasticsearchParseException("pipeline [" + id + "] cannot have an empty on_failure option defined", new Object[0]);
            }
            CompoundProcessor compoundProcessor = new CompoundProcessor(false, Collections.unmodifiableList(processors), Collections.unmodifiableList(onFailureProcessors));
            return new Pipeline(id, description, version, compoundProcessor);
        }
    }
}

