/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.CheckIndex;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexNotFoundException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexWriterConfig;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.NoMergePolicy;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentCommitInfo;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentInfos;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.BufferedChecksum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.ByteArrayDataInput;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.FilterDirectory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.Lock;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.SimpleFSDirectory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.UUIDs;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.Streams;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.Loggers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.SingleObjectCache;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.RefCounted;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.iterable.Iterables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.NodeEnvironment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.ShardLock;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.ShardLockObtainFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.CombinedDeletionPolicy;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.seqno.SequenceNumbers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store.DirectoryService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store.StoreFileMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store.StoreStats;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store.VerifyingIndexOutput;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class Store
extends AbstractIndexShardComponent
implements Closeable,
RefCounted {
    static final String CODEC = "store";
    static final int VERSION_WRITE_THROWABLE = 2;
    static final int VERSION_STACK_TRACE = 1;
    static final int VERSION_START = 0;
    static final int VERSION = 2;
    static final String CORRUPTED = "corrupted_";
    public static final Setting<TimeValue> INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.store.stats_refresh_interval", TimeValue.timeValueSeconds(10L), Setting.Property.IndexScope);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final StoreDirectory directory;
    private final ReentrantReadWriteLock metadataLock = new ReentrantReadWriteLock();
    private final ShardLock shardLock;
    private final OnClose onClose;
    private final SingleObjectCache<StoreStats> statsCache;
    private final AbstractRefCounted refCounter = new AbstractRefCounted("store"){

        @Override
        protected void closeInternal() {
            Store.this.closeInternal();
        }
    };

    public Store(ShardId shardId, IndexSettings indexSettings, DirectoryService directoryService, ShardLock shardLock) throws IOException {
        this(shardId, indexSettings, directoryService, shardLock, OnClose.EMPTY);
    }

    public Store(ShardId shardId, IndexSettings indexSettings, DirectoryService directoryService, ShardLock shardLock, OnClose onClose) throws IOException {
        super(shardId, indexSettings);
        Settings settings = indexSettings.getSettings();
        this.directory = new StoreDirectory(directoryService.newDirectory(), Loggers.getLogger("index.store.deletes", settings, shardId, new String[0]));
        this.shardLock = shardLock;
        this.onClose = onClose;
        TimeValue refreshInterval = indexSettings.getValue(INDEX_STORE_STATS_REFRESH_INTERVAL_SETTING);
        this.statsCache = new StoreStatsCache(refreshInterval, this.directory);
        this.logger.debug("store stats are refreshed with refresh_interval [{}]", (Object)refreshInterval);
        assert (onClose != null);
        assert (shardLock != null);
        assert (shardLock.getShardId().equals(shardId));
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public SegmentInfos readLastCommittedSegmentsInfo() throws IOException {
        this.failIfCorrupted();
        try {
            return Store.readSegmentsInfo(null, this.directory());
        }
        catch (CorruptIndexException ex) {
            this.markStoreCorrupted(ex);
            throw ex;
        }
    }

    private static SegmentInfos readSegmentsInfo(IndexCommit commit, Directory directory) throws IOException {
        assert (commit == null || commit.getDirectory() == directory);
        try {
            return commit == null ? Lucene.readSegmentInfos(directory) : Lucene.readSegmentInfos(commit);
        }
        catch (EOFException eof) {
            throw new CorruptIndexException("Read past EOF while reading segment infos", "commit(" + commit + ")", (Throwable)eof);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception ex) {
            throw new CorruptIndexException("Hit unexpected exception while reading segment infos", "commit(" + commit + ")", (Throwable)ex);
        }
    }

    public static SequenceNumbers.CommitInfo loadSeqNoInfo(IndexCommit commit) throws IOException {
        Map<String, String> userData = commit.getUserData();
        return SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userData.entrySet());
    }

    final void ensureOpen() {
        if (this.refCounter.refCount() <= 0) {
            throw new AlreadyClosedException("store is already closed");
        }
    }

    public MetadataSnapshot getMetadata(IndexCommit commit) throws IOException {
        return this.getMetadata(commit, false);
    }

    /*
     * Exception decompiling
     */
    public MetadataSnapshot getMetadata(IndexCommit commit, boolean lockDirectory) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTempFilesSafe(Map<String, String> tempFileMap) throws IOException {
        Map.Entry[] entries = tempFileMap.entrySet().toArray(new Map.Entry[tempFileMap.size()]);
        ArrayUtil.timSort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                String left = o1.getValue();
                String right = o2.getValue();
                if (left.startsWith("segments") || right.startsWith("segments")) {
                    if (!left.startsWith("segments")) {
                        return -1;
                    }
                    if (!right.startsWith("segments")) {
                        return 1;
                    }
                }
                return left.compareTo(right);
            }
        });
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory().obtainLock("write.lock");){
            for (Map.Entry entry : entries) {
                String tempFile = (String)entry.getKey();
                String origFile = (String)entry.getValue();
                try {
                    this.directory.deleteFile(origFile);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                }
                catch (Exception ex) {
                    this.logger.debug(() -> new ParameterizedMessage("failed to delete file [{}]", (Object)origFile), (Throwable)ex);
                }
                this.directory.rename(tempFile, origFile);
                String remove = tempFileMap.remove(tempFile);
                assert (remove != null);
            }
            this.directory.syncMetaData();
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public CheckIndex.Status checkIndex(PrintStream out) throws IOException {
        this.metadataLock.writeLock().lock();
        try {
            CheckIndex.Status status;
            CheckIndex checkIndex = new CheckIndex(this.directory);
            Throwable throwable = null;
            try {
                checkIndex.setInfoStream(out);
                status = checkIndex.checkIndex();
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    Store.$closeResource(throwable, checkIndex);
                    throw throwable3;
                }
            }
            Store.$closeResource(throwable, checkIndex);
            return status;
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exorciseIndex(CheckIndex.Status status) throws IOException {
        this.metadataLock.writeLock().lock();
        try (CheckIndex checkIndex = new CheckIndex(this.directory);){
            checkIndex.exorciseIndex(status);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    public StoreStats stats() throws IOException {
        this.ensureOpen();
        return this.statsCache.getOrRefresh();
    }

    @Override
    public final void incRef() {
        this.refCounter.incRef();
    }

    @Override
    public final boolean tryIncRef() {
        return this.refCounter.tryIncRef();
    }

    @Override
    public final void decRef() {
        this.refCounter.decRef();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.decRef();
            this.logger.debug("store reference count on close: {}", (Object)this.refCounter.refCount());
        }
    }

    private void closeInternal() {
        try {
            try {
                this.directory.innerClose();
            }
            finally {
                this.onClose.accept(this.shardLock);
            }
        }
        catch (IOException e) {
            try {
                this.logger.debug("failed to close directory", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(this.shardLock);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.shardLock);
        }
        IOUtils.closeWhileHandlingException(this.shardLock);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static MetadataSnapshot readMetadataSnapshot(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException {
        try {
            Throwable throwable = null;
            try (ShardLock lock = shardLocker.lock(shardId, TimeUnit.SECONDS.toMillis(5L));){
                MetadataSnapshot metadataSnapshot;
                SimpleFSDirectory dir = new SimpleFSDirectory(indexLocation);
                Throwable throwable2 = null;
                try {
                    Store.failIfCorrupted(dir, shardId);
                    metadataSnapshot = new MetadataSnapshot(null, dir, logger);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            Store.$closeResource(throwable2, dir);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                Store.$closeResource(throwable2, dir);
                return metadataSnapshot;
            }
        }
        catch (IndexNotFoundException lock) {
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            logger.info("Failed to open / find files while reading metadata snapshot");
        }
        catch (ShardLockObtainFailedException ex) {
            logger.info(() -> new ParameterizedMessage("{}: failed to obtain shard lock", (Object)shardId), (Throwable)ex);
        }
        return MetadataSnapshot.EMPTY;
    }

    public static boolean canOpenIndex(Logger logger, Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker) throws IOException {
        try {
            Store.tryOpenIndex(indexLocation, shardId, shardLocker, logger);
        }
        catch (Exception ex) {
            logger.trace(() -> new ParameterizedMessage("Can't open index for path [{}]", (Object)indexLocation), (Throwable)ex);
            return false;
        }
        return true;
    }

    public static void tryOpenIndex(Path indexLocation, ShardId shardId, NodeEnvironment.ShardLocker shardLocker, Logger logger) throws IOException, ShardLockObtainFailedException {
        try (ShardLock lock = shardLocker.lock(shardId, TimeUnit.SECONDS.toMillis(5L));
             SimpleFSDirectory dir = new SimpleFSDirectory(indexLocation);){
            Store.failIfCorrupted(dir, shardId);
            SegmentInfos segInfo = Lucene.readSegmentInfos(dir);
            logger.trace("{} loaded segment info [{}]", (Object)shardId, (Object)segInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IndexOutput createVerifyingOutput(String fileName, StoreFileMetaData metadata, IOContext context) throws IOException {
        IndexOutput output = this.directory().createOutput(fileName, context);
        boolean success = false;
        try {
            if ($assertionsDisabled) return new LuceneVerifyingIndexOutput(metadata, output);
            if (metadata.writtenBy() != null) return new LuceneVerifyingIndexOutput(metadata, output);
            throw new AssertionError();
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(output);
            throw throwable;
        }
    }

    public static void verify(IndexOutput output) throws IOException {
        if (output instanceof VerifyingIndexOutput) {
            ((VerifyingIndexOutput)output).verify();
        }
    }

    public IndexInput openVerifyingInput(String filename, IOContext context, StoreFileMetaData metadata) throws IOException {
        assert (metadata.writtenBy() != null);
        return new VerifyingIndexInput(this.directory().openInput(filename, context));
    }

    public static void verify(IndexInput input) throws IOException {
        if (input instanceof VerifyingIndexInput) {
            ((VerifyingIndexInput)input).verify();
        }
    }

    public boolean checkIntegrityNoException(StoreFileMetaData md) {
        return Store.checkIntegrityNoException(md, this.directory());
    }

    public static boolean checkIntegrityNoException(StoreFileMetaData md, Directory directory) {
        try {
            Store.checkIntegrity(md, directory);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void checkIntegrity(StoreFileMetaData md, Directory directory) throws IOException {
        try (IndexInput input = directory.openInput(md.name(), IOContext.READONCE);){
            if (input.length() != md.length()) {
                throw new CorruptIndexException("expected length=" + md.length() + " != actual length: " + input.length() + " : file truncated?", input);
            }
            String checksum = Store.digestToString(CodecUtil.checksumEntireFile(input));
            if (!checksum.equals(md.checksum())) {
                throw new CorruptIndexException("inconsistent metadata: lucene checksum=" + checksum + ", metadata checksum=" + md.checksum(), input);
            }
        }
    }

    public boolean isMarkedCorrupted() throws IOException {
        String[] files;
        this.ensureOpen();
        for (String file : files = this.directory().listAll()) {
            if (!file.startsWith(CORRUPTED)) continue;
            return true;
        }
        return false;
    }

    public void removeCorruptionMarker() throws IOException {
        String[] files;
        this.ensureOpen();
        Directory directory = this.directory();
        IOException firstException = null;
        for (String file : files = directory.listAll()) {
            if (!file.startsWith(CORRUPTED)) continue;
            try {
                directory.deleteFile(file);
            }
            catch (IOException ex) {
                if (firstException == null) {
                    firstException = ex;
                    continue;
                }
                firstException.addSuppressed(ex);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public void failIfCorrupted() throws IOException {
        this.ensureOpen();
        Store.failIfCorrupted(this.directory, this.shardId);
    }

    private static void failIfCorrupted(Directory directory, ShardId shardId) throws IOException {
        String[] files = directory.listAll();
        ArrayList<CorruptIndexException> ex = new ArrayList<CorruptIndexException>();
        for (String file : files) {
            if (!file.startsWith(CORRUPTED)) continue;
            try (ChecksumIndexInput input = directory.openChecksumInput(file, IOContext.READONCE);){
                int version = CodecUtil.checkHeader(input, CODEC, 0, 2);
                if (version == 2) {
                    int size = input.readVInt();
                    byte[] buffer = new byte[size];
                    input.readBytes(buffer, 0, buffer.length);
                    StreamInput in = StreamInput.wrap(buffer);
                    Object t = in.readException();
                    if (t instanceof CorruptIndexException) {
                        ex.add((CorruptIndexException)t);
                    } else {
                        ex.add(new CorruptIndexException(((Throwable)t).getMessage(), "preexisting_corruption", (Throwable)t));
                    }
                } else {
                    assert (version == 0 || version == 1);
                    String msg = input.readString();
                    StringBuilder builder = new StringBuilder(shardId.toString());
                    builder.append(" Preexisting corrupted index [");
                    builder.append(file).append("] caused by: ");
                    builder.append(msg);
                    if (version == 1) {
                        builder.append(System.lineSeparator());
                        builder.append(input.readString());
                    }
                    ex.add(new CorruptIndexException(builder.toString(), "preexisting_corruption"));
                }
                CodecUtil.checkFooter(input);
            }
        }
        if (!ex.isEmpty()) {
            ExceptionsHelper.rethrowAndSuppress(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAndVerify(String reason, MetadataSnapshot sourceMetaData) throws IOException {
        this.metadataLock.writeLock().lock();
        try (Lock writeLock = this.directory.obtainLock("write.lock");){
            for (String existingFile : this.directory.listAll()) {
                if (Store.isAutogenerated(existingFile) || sourceMetaData.contains(existingFile)) continue;
                try {
                    this.directory.deleteFile(reason, existingFile);
                }
                catch (IOException ex) {
                    if (existingFile.startsWith("segments") || existingFile.equals("segments.gen") || existingFile.startsWith(CORRUPTED)) {
                        throw new IllegalStateException("Can't delete " + existingFile + " - cleanup failed", ex);
                    }
                    this.logger.debug(() -> new ParameterizedMessage("failed to delete file [{}]", (Object)existingFile), (Throwable)ex);
                }
            }
            this.directory.syncMetaData();
            MetadataSnapshot metadataOrEmpty = this.getMetadata(null);
            this.verifyAfterCleanup(sourceMetaData, metadataOrEmpty);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    final void verifyAfterCleanup(MetadataSnapshot sourceMetaData, MetadataSnapshot targetMetaData) {
        RecoveryDiff recoveryDiff = targetMetaData.recoveryDiff(sourceMetaData);
        if (recoveryDiff.identical.size() != recoveryDiff.size()) {
            if (recoveryDiff.missing.isEmpty()) {
                for (StoreFileMetaData meta : recoveryDiff.different) {
                    StoreFileMetaData remote;
                    StoreFileMetaData local = targetMetaData.get(meta.name());
                    if (local.isSame(remote = sourceMetaData.get(meta.name()))) continue;
                    this.logger.debug("Files are different on the recovery target: {} ", (Object)recoveryDiff);
                    throw new IllegalStateException("local version: " + local + " is different from remote version after recovery: " + remote, null);
                }
            } else {
                this.logger.debug("Files are missing on the recovery target: {} ", (Object)recoveryDiff);
                throw new IllegalStateException("Files are missing on the recovery target: [different=" + recoveryDiff.different + ", missing=" + recoveryDiff.missing + ']', null);
            }
        }
    }

    public int refCount() {
        return this.refCounter.refCount();
    }

    public static boolean isAutogenerated(String name) {
        return "write.lock".equals(name);
    }

    public static String digestToString(long digest) {
        return Long.toString(digest, 36);
    }

    public void deleteQuiet(String ... files) {
        this.ensureOpen();
        StoreDirectory directory = this.directory;
        for (String file : files) {
            try {
                directory.deleteFile("Store.deleteQuiet", file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void markStoreCorrupted(IOException exception) throws IOException {
        this.ensureOpen();
        if (!this.isMarkedCorrupted()) {
            String uuid = CORRUPTED + UUIDs.randomBase64UUID();
            try (IndexOutput output = this.directory().createOutput(uuid, IOContext.DEFAULT);){
                CodecUtil.writeHeader(output, CODEC, 2);
                BytesStreamOutput out = new BytesStreamOutput();
                out.writeException(exception);
                BytesReference bytes = out.bytes();
                output.writeVInt(bytes.length());
                BytesRef ref = bytes.toBytesRef();
                output.writeBytes(ref.bytes, ref.offset, ref.length);
                CodecUtil.writeFooter(output);
            }
            catch (IOException ex) {
                this.logger.warn("Can't mark store as corrupted", (Throwable)ex);
            }
            this.directory().sync(Collections.singleton(uuid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmpty() throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.CREATE, this.directory, null);){
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("local_checkpoint", Long.toString(-1L));
            map.put("max_seq_no", Long.toString(-1L));
            map.put("max_unsafe_auto_id_timestamp", "-1");
            this.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrapNewHistory() throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.APPEND, this.directory, null);){
            Map<String, String> userData = this.getUserData(writer);
            SequenceNumbers.CommitInfo seqno = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userData.entrySet());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("history_uuid", UUIDs.randomBase64UUID());
            map.put("max_seq_no", Long.toString(seqno.maxSeqNo));
            map.put("local_checkpoint", Long.toString(seqno.maxSeqNo));
            this.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateIndexWithNewTranslog(String translogUUID) throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.APPEND, this.directory, null);){
            if (translogUUID.equals(this.getUserData(writer).get("translog_uuid"))) {
                throw new IllegalArgumentException("a new translog uuid can't be equal to existing one. got [" + translogUUID + "]");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("translog_generation", "1");
            map.put("translog_uuid", translogUUID);
            this.updateCommitData(writer, map);
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureIndexHas6xCommitTags() throws IOException {
        this.metadataLock.writeLock().lock();
        try (IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.APPEND, this.directory, null);){
            Map<String, String> userData = this.getUserData(writer);
            HashMap<String, String> maps = new HashMap<String, String>();
            if (!userData.containsKey("history_uuid")) {
                maps.put("history_uuid", UUIDs.randomBase64UUID());
            }
            if (!userData.containsKey("max_seq_no")) {
                assert (!userData.containsKey("local_checkpoint")) : "Inconsistent sequence number markers in commit [" + userData + "]";
                maps.put("max_seq_no", Long.toString(-1L));
                maps.put("local_checkpoint", Long.toString(-1L));
            }
            if (!userData.containsKey("max_unsafe_auto_id_timestamp")) {
                maps.put("max_unsafe_auto_id_timestamp", "-1");
            }
            if (!maps.isEmpty()) {
                this.updateCommitData(writer, maps);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.metadataLock.writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimUnsafeCommits(long lastSyncedGlobalCheckpoint, long minRetainedTranslogGen, Version indexVersionCreated) throws IOException {
        block17: {
            this.metadataLock.writeLock().lock();
            try {
                IndexCommit startingIndexCommit;
                List<IndexCommit> existingCommits = DirectoryReader.listCommits(this.directory);
                if (existingCommits.isEmpty()) {
                    throw new IllegalArgumentException("No index found to trim");
                }
                String translogUUID = existingCommits.get(existingCommits.size() - 1).getUserData().get("translog_uuid");
                if (indexVersionCreated.before(Version.V_6_2_0)) {
                    if (minRetainedTranslogGen == -1L) {
                        startingIndexCommit = existingCommits.get(existingCommits.size() - 1);
                    } else {
                        ArrayList<IndexCommit> recoverableCommits = new ArrayList<IndexCommit>();
                        for (IndexCommit commit : existingCommits) {
                            if (minRetainedTranslogGen > Long.parseLong(commit.getUserData().get("translog_generation"))) continue;
                            recoverableCommits.add(commit);
                        }
                        assert (!recoverableCommits.isEmpty()) : "No commit point with translog found; commits [" + existingCommits + "], minRetainedTranslogGen [" + minRetainedTranslogGen + "]";
                        startingIndexCommit = CombinedDeletionPolicy.findSafeCommitPoint(recoverableCommits, lastSyncedGlobalCheckpoint);
                    }
                } else {
                    startingIndexCommit = CombinedDeletionPolicy.findSafeCommitPoint(existingCommits, lastSyncedGlobalCheckpoint);
                }
                if (!translogUUID.equals(startingIndexCommit.getUserData().get("translog_uuid"))) {
                    throw new IllegalStateException("starting commit translog uuid [" + startingIndexCommit.getUserData().get("translog_uuid") + "] is not equal to last commit's translog uuid [" + translogUUID + "]");
                }
                if (startingIndexCommit.equals(existingCommits.get(existingCommits.size() - 1))) break block17;
                IndexWriter writer = Store.newIndexWriter(IndexWriterConfig.OpenMode.APPEND, this.directory, startingIndexCommit);
                Object object = null;
                try {
                    writer.setLiveCommitData(startingIndexCommit.getUserData().entrySet());
                    writer.commit();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        Store.$closeResource((Throwable)object, writer);
                    }
                }
            }
            finally {
                this.metadataLock.writeLock().unlock();
            }
        }
    }

    private void updateCommitData(IndexWriter writer, Map<String, String> keysToUpdate) throws IOException {
        Map<String, String> userData = this.getUserData(writer);
        userData.putAll(keysToUpdate);
        writer.setLiveCommitData(userData.entrySet());
        writer.commit();
    }

    private Map<String, String> getUserData(IndexWriter writer) {
        HashMap<String, String> userData = new HashMap<String, String>();
        writer.getLiveCommitData().forEach(e -> userData.put((String)e.getKey(), (String)e.getValue()));
        return userData;
    }

    private static IndexWriter newIndexWriter(IndexWriterConfig.OpenMode openMode, Directory dir, IndexCommit commit) throws IOException {
        assert (openMode == IndexWriterConfig.OpenMode.APPEND || commit == null) : "can't specify create flag with a commit";
        IndexWriterConfig iwc = new IndexWriterConfig(null).setCommitOnClose(false).setIndexCommit(commit).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(openMode);
        return new IndexWriter(dir, iwc);
    }

    private static /* synthetic */ void lambda$getMetadata$0() throws IOException {
    }

    private static class StoreStatsCache
    extends SingleObjectCache<StoreStats> {
        private final Directory directory;

        StoreStatsCache(TimeValue refreshInterval, Directory directory) throws IOException {
            super(refreshInterval, new StoreStats(StoreStatsCache.estimateSize(directory)));
            this.directory = directory;
        }

        @Override
        protected StoreStats refresh() {
            try {
                return new StoreStats(StoreStatsCache.estimateSize(this.directory));
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to refresh store stats", (Throwable)ex, new Object[0]);
            }
        }

        private static long estimateSize(Directory directory) throws IOException {
            String[] files;
            long estimatedSize = 0L;
            for (String file : files = directory.listAll()) {
                try {
                    estimatedSize += directory.fileLength(file);
                }
                catch (FileNotFoundException | AccessDeniedException | NoSuchFileException iOException) {
                    // empty catch block
                }
            }
            return estimatedSize;
        }
    }

    public static interface OnClose
    extends Consumer<ShardLock> {
        public static final OnClose EMPTY = new OnClose(){

            @Override
            public void accept(ShardLock Lock2) {
            }
        };
    }

    static class VerifyingIndexInput
    extends ChecksumIndexInput {
        private final IndexInput input;
        private final Checksum digest;
        private final long checksumPosition;
        private final byte[] checksum = new byte[8];
        private long verifiedPosition = 0L;

        VerifyingIndexInput(IndexInput input) {
            this(input, new BufferedChecksum(new CRC32()));
        }

        VerifyingIndexInput(IndexInput input, Checksum digest) {
            super("VerifyingIndexInput(" + input + ")");
            this.input = input;
            this.digest = digest;
            this.checksumPosition = input.length() - 8L;
        }

        @Override
        public byte readByte() throws IOException {
            long pos = this.input.getFilePointer();
            byte b = this.input.readByte();
            if (++pos > this.verifiedPosition) {
                if (pos <= this.checksumPosition) {
                    this.digest.update(b);
                } else {
                    this.checksum[(int)(pos - this.checksumPosition - 1L)] = b;
                }
                this.verifiedPosition = pos;
            }
            return b;
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            long pos = this.input.getFilePointer();
            this.input.readBytes(b, offset, len);
            if (pos + (long)len > this.verifiedPosition) {
                int alreadyVerified = (int)Math.max(0L, this.verifiedPosition - pos);
                if (pos < this.checksumPosition) {
                    if (pos + (long)len < this.checksumPosition) {
                        this.digest.update(b, offset + alreadyVerified, len - alreadyVerified);
                    } else {
                        int checksumOffset = (int)(this.checksumPosition - pos);
                        if (checksumOffset - alreadyVerified > 0) {
                            this.digest.update(b, offset + alreadyVerified, checksumOffset - alreadyVerified);
                        }
                        System.arraycopy(b, offset + checksumOffset, this.checksum, 0, len - checksumOffset);
                    }
                } else {
                    assert (pos - this.checksumPosition < 8L);
                    System.arraycopy(b, offset, this.checksum, (int)(pos - this.checksumPosition), len);
                }
                this.verifiedPosition = pos + (long)len;
            }
        }

        @Override
        public long getChecksum() {
            return this.digest.getValue();
        }

        @Override
        public void seek(long pos) throws IOException {
            if (pos < this.verifiedPosition) {
                this.input.seek(pos);
            } else if (this.verifiedPosition > this.getFilePointer()) {
                this.input.seek(this.verifiedPosition);
                this.skipBytes(pos - this.verifiedPosition);
            } else {
                this.skipBytes(pos - this.getFilePointer());
            }
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }

        @Override
        public long getFilePointer() {
            return this.input.getFilePointer();
        }

        @Override
        public long length() {
            return this.input.length();
        }

        @Override
        public IndexInput clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getStoredChecksum() {
            return new ByteArrayDataInput(this.checksum).readLong();
        }

        public long verify() throws CorruptIndexException {
            long storedChecksum = this.getStoredChecksum();
            if (this.getChecksum() == storedChecksum) {
                return storedChecksum;
            }
            throw new CorruptIndexException("verification failed : calculated=" + Store.digestToString(this.getChecksum()) + " stored=" + Store.digestToString(storedChecksum), this);
        }
    }

    static class LuceneVerifyingIndexOutput
    extends VerifyingIndexOutput {
        private final StoreFileMetaData metadata;
        private long writtenBytes;
        private final long checksumPosition;
        private String actualChecksum;
        private final byte[] footerChecksum = new byte[8];

        LuceneVerifyingIndexOutput(StoreFileMetaData metadata, IndexOutput out) {
            super(out);
            this.metadata = metadata;
            this.checksumPosition = metadata.length() - 8L;
        }

        @Override
        public void verify() throws IOException {
            String footerDigest = null;
            if (this.metadata.checksum().equals(this.actualChecksum) && this.writtenBytes == this.metadata.length()) {
                ByteArrayIndexInput indexInput = new ByteArrayIndexInput("checksum", this.footerChecksum);
                footerDigest = Store.digestToString(indexInput.readLong());
                if (this.metadata.checksum().equals(footerDigest)) {
                    return;
                }
            }
            throw new CorruptIndexException("verification failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " footer=" + footerDigest + " writtenLength=" + this.writtenBytes + " expectedLength=" + this.metadata.length() + " (resource=" + this.metadata.toString() + ")", "VerifyingIndexOutput(" + this.metadata.name() + ")");
        }

        @Override
        public void writeByte(byte b) throws IOException {
            long writtenBytes;
            if ((writtenBytes = this.writtenBytes++) >= this.checksumPosition) {
                int index;
                if (writtenBytes == this.checksumPosition) {
                    this.readAndCompareChecksum();
                }
                if ((index = Math.toIntExact(writtenBytes - this.checksumPosition)) < this.footerChecksum.length) {
                    this.footerChecksum[index] = b;
                    if (index == this.footerChecksum.length - 1) {
                        this.verify();
                    }
                } else {
                    this.verify();
                    throw new AssertionError((Object)("write past EOF expected length: " + this.metadata.length() + " writtenBytes: " + writtenBytes));
                }
            }
            this.out.writeByte(b);
        }

        private void readAndCompareChecksum() throws IOException {
            this.actualChecksum = Store.digestToString(this.getChecksum());
            if (!this.metadata.checksum().equals(this.actualChecksum)) {
                throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + this.metadata.checksum() + " actual=" + this.actualChecksum + " (resource=" + this.metadata.toString() + ")", "VerifyingIndexOutput(" + this.metadata.name() + ")");
            }
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            if (this.writtenBytes + (long)length > this.checksumPosition) {
                for (int i = 0; i < length; ++i) {
                    this.writeByte(b[offset + i]);
                }
            } else {
                this.out.writeBytes(b, offset, length);
                this.writtenBytes += (long)length;
            }
        }
    }

    public static final class RecoveryDiff {
        public final List<StoreFileMetaData> identical;
        public final List<StoreFileMetaData> different;
        public final List<StoreFileMetaData> missing;

        RecoveryDiff(List<StoreFileMetaData> identical, List<StoreFileMetaData> different, List<StoreFileMetaData> missing) {
            this.identical = identical;
            this.different = different;
            this.missing = missing;
        }

        public int size() {
            return this.identical.size() + this.different.size() + this.missing.size();
        }

        public String toString() {
            return "RecoveryDiff{identical=" + this.identical + ", different=" + this.different + ", missing=" + this.missing + '}';
        }
    }

    public static final class MetadataSnapshot
    implements Iterable<StoreFileMetaData>,
    Writeable {
        private final Map<String, StoreFileMetaData> metadata;
        public static final MetadataSnapshot EMPTY = new MetadataSnapshot();
        private final Map<String, String> commitUserData;
        private final long numDocs;
        private static final String DEL_FILE_EXTENSION = "del";
        private static final String LIV_FILE_EXTENSION = "liv";
        private static final String FIELD_INFOS_FILE_EXTENSION = "fnm";
        private static final String SEGMENT_INFO_EXTENSION = "si";

        public MetadataSnapshot(Map<String, StoreFileMetaData> metadata, Map<String, String> commitUserData, long numDocs) {
            this.metadata = metadata;
            this.commitUserData = commitUserData;
            this.numDocs = numDocs;
        }

        MetadataSnapshot() {
            this.metadata = Collections.emptyMap();
            this.commitUserData = Collections.emptyMap();
            this.numDocs = 0L;
        }

        MetadataSnapshot(IndexCommit commit, Directory directory, Logger logger) throws IOException {
            LoadedMetadata loadedMetadata = MetadataSnapshot.loadMetadata(commit, directory, logger);
            this.metadata = loadedMetadata.fileMetadata;
            this.commitUserData = loadedMetadata.userData;
            this.numDocs = loadedMetadata.numDocs;
            assert (this.metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        public MetadataSnapshot(StreamInput in) throws IOException {
            int num;
            int size = in.readVInt();
            HashMap<String, StoreFileMetaData> metadata = new HashMap<String, StoreFileMetaData>();
            for (int i = 0; i < size; ++i) {
                StoreFileMetaData meta = new StoreFileMetaData(in);
                metadata.put(meta.name(), meta);
            }
            HashMap<String, String> commitUserData = new HashMap<String, String>();
            for (int i = num = in.readVInt(); i > 0; --i) {
                commitUserData.put(in.readString(), in.readString());
            }
            this.metadata = Collections.unmodifiableMap(metadata);
            this.commitUserData = Collections.unmodifiableMap(commitUserData);
            this.numDocs = in.readLong();
            assert (metadata.isEmpty() || this.numSegmentFiles() == 1) : "numSegmentFiles: " + this.numSegmentFiles();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.metadata.size());
            for (StoreFileMetaData storeFileMetaData : this) {
                storeFileMetaData.writeTo(out);
            }
            out.writeVInt(this.commitUserData.size());
            for (Map.Entry entry : this.commitUserData.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeString((String)entry.getValue());
            }
            out.writeLong(this.numDocs);
        }

        public long getNumDocs() {
            return this.numDocs;
        }

        static LoadedMetadata loadMetadata(IndexCommit commit, Directory directory, Logger logger) throws IOException {
            long numDocs;
            HashMap<String, StoreFileMetaData> builder = new HashMap<String, StoreFileMetaData>();
            HashMap<String, String> commitUserDataBuilder = new HashMap<String, String>();
            try {
                SegmentInfos segmentCommitInfos = Store.readSegmentsInfo(commit, directory);
                numDocs = Lucene.getNumDocs(segmentCommitInfos);
                commitUserDataBuilder.putAll(segmentCommitInfos.getUserData());
                org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Version maxVersion = segmentCommitInfos.getMinSegmentLuceneVersion();
                for (SegmentCommitInfo info : segmentCommitInfos) {
                    org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Version version = info.info.getVersion();
                    if (version == null) {
                        throw new IllegalArgumentException("expected valid version value: " + info.info.toString());
                    }
                    if (version.onOrAfter(maxVersion)) {
                        maxVersion = version;
                    }
                    for (String file : info.files()) {
                        MetadataSnapshot.checksumFromLuceneFile(directory, file, builder, logger, version, SEGMENT_INFO_EXTENSION.equals(IndexFileNames.getExtension(file)));
                    }
                }
                if (maxVersion == null) {
                    maxVersion = Version.CURRENT.minimumIndexCompatibilityVersion().luceneVersion;
                }
                String segmentsFile = segmentCommitInfos.getSegmentsFileName();
                MetadataSnapshot.checksumFromLuceneFile(directory, segmentsFile, builder, logger, maxVersion, true);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException | IndexNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                try {
                    logger.warn(() -> new ParameterizedMessage("failed to build store metadata. checking segment info integrity (with commit [{}])", (Object)(commit == null ? "no" : "yes")), (Throwable)ex);
                    Lucene.checkSegmentInfoIntegrity(directory);
                }
                catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException cex) {
                    cex.addSuppressed(ex);
                    throw cex;
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    throw inner;
                }
                throw ex;
            }
            return new LoadedMetadata(Collections.unmodifiableMap(builder), Collections.unmodifiableMap(commitUserDataBuilder), numDocs);
        }

        private static void checksumFromLuceneFile(Directory directory, String file, Map<String, StoreFileMetaData> builder, Logger logger, org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Version version, boolean readFileAsHash) throws IOException {
            BytesRefBuilder fileHash = new BytesRefBuilder();
            try (IndexInput in = directory.openInput(file, IOContext.READONCE);){
                String checksum;
                long length;
                try {
                    length = in.length();
                    if (length < (long)CodecUtil.footerLength()) {
                        throw new CorruptIndexException("Can't retrieve checksum from file: " + file + " file length must be >= " + CodecUtil.footerLength() + " but was: " + in.length(), in);
                    }
                    if (readFileAsHash) {
                        VerifyingIndexInput verifyingIndexInput = new VerifyingIndexInput(in);
                        MetadataSnapshot.hashFile(fileHash, new InputStreamIndexInput(verifyingIndexInput, length), length);
                        checksum = Store.digestToString(verifyingIndexInput.verify());
                    } else {
                        checksum = Store.digestToString(CodecUtil.retrieveChecksum(in));
                    }
                }
                catch (Exception ex) {
                    logger.debug(() -> new ParameterizedMessage("Can retrieve checksum from file [{}]", (Object)file), (Throwable)ex);
                    throw ex;
                }
                builder.put(file, new StoreFileMetaData(file, length, checksum, version, fileHash.get()));
            }
        }

        public static void hashFile(BytesRefBuilder fileHash, InputStream in, long size) throws IOException {
            int len = (int)Math.min(0x100000L, size);
            fileHash.grow(len);
            fileHash.setLength(len);
            int readBytes = Streams.readFully(in, fileHash.bytes(), 0, len);
            assert (readBytes == len) : Integer.toString(readBytes) + " != " + Integer.toString(len);
            assert (fileHash.length() == len) : Integer.toString(fileHash.length()) + " != " + Integer.toString(len);
        }

        @Override
        public Iterator<StoreFileMetaData> iterator() {
            return this.metadata.values().iterator();
        }

        public StoreFileMetaData get(String name) {
            return this.metadata.get(name);
        }

        public Map<String, StoreFileMetaData> asMap() {
            return this.metadata;
        }

        public RecoveryDiff recoveryDiff(MetadataSnapshot recoveryTargetSnapshot) {
            ArrayList identical = new ArrayList();
            ArrayList<StoreFileMetaData> different = new ArrayList<StoreFileMetaData>();
            ArrayList<StoreFileMetaData> missing = new ArrayList<StoreFileMetaData>();
            HashMap<String, ArrayList<Object>> perSegment = new HashMap<String, ArrayList<Object>>();
            ArrayList<Object> perCommitStoreFiles = new ArrayList<Object>();
            for (Object meta : this) {
                if ("segments.gen".equals(((StoreFileMetaData)meta).name())) continue;
                String segmentId = IndexFileNames.parseSegmentName(((StoreFileMetaData)meta).name());
                String extension = IndexFileNames.getExtension(((StoreFileMetaData)meta).name());
                assert (!FIELD_INFOS_FILE_EXTENSION.equals(extension) || IndexFileNames.stripExtension(IndexFileNames.stripSegmentName(((StoreFileMetaData)meta).name())).isEmpty()) : "FieldInfos are generational but updateable DV are not supported in elasticsearch";
                if ("segments".equals(segmentId) || DEL_FILE_EXTENSION.equals(extension) || LIV_FILE_EXTENSION.equals(extension)) {
                    perCommitStoreFiles.add(meta);
                    continue;
                }
                ArrayList<Object> perSegStoreFiles = (ArrayList<Object>)perSegment.get(segmentId);
                if (perSegStoreFiles == null) {
                    perSegStoreFiles = new ArrayList<Object>();
                    perSegment.put(segmentId, perSegStoreFiles);
                }
                perSegStoreFiles.add(meta);
            }
            ArrayList<StoreFileMetaData> identicalFiles = new ArrayList<StoreFileMetaData>();
            for (List segmentFiles : Iterables.concat(perSegment.values(), Collections.singleton(perCommitStoreFiles))) {
                identicalFiles.clear();
                boolean consistent = true;
                for (StoreFileMetaData meta : segmentFiles) {
                    StoreFileMetaData storeFileMetaData = recoveryTargetSnapshot.get(meta.name());
                    if (storeFileMetaData == null) {
                        consistent = false;
                        missing.add(meta);
                        continue;
                    }
                    if (!storeFileMetaData.isSame(meta)) {
                        consistent = false;
                        different.add(meta);
                        continue;
                    }
                    identicalFiles.add(meta);
                }
                if (consistent) {
                    identical.addAll(identicalFiles);
                    continue;
                }
                different.addAll(identicalFiles);
            }
            RecoveryDiff recoveryDiff = new RecoveryDiff(Collections.unmodifiableList(identical), Collections.unmodifiableList(different), Collections.unmodifiableList(missing));
            assert (recoveryDiff.size() == this.metadata.size() - (this.metadata.containsKey("segments.gen") ? 1 : 0)) : "some files are missing recoveryDiff size: [" + recoveryDiff.size() + "] metadata size: [" + this.metadata.size() + "] contains  segments.gen: [" + this.metadata.containsKey("segments.gen") + "]";
            return recoveryDiff;
        }

        public int size() {
            return this.metadata.size();
        }

        public Map<String, String> getCommitUserData() {
            return this.commitUserData;
        }

        public String getHistoryUUID() {
            return this.commitUserData.get("history_uuid");
        }

        public String getTranslogUUID() {
            return this.commitUserData.get("translog_uuid");
        }

        public boolean contains(String existingFile) {
            return this.metadata.containsKey(existingFile);
        }

        public StoreFileMetaData getSegmentsFile() {
            for (StoreFileMetaData file : this) {
                if (!file.name().startsWith("segments")) continue;
                return file;
            }
            assert (this.metadata.isEmpty());
            return null;
        }

        private int numSegmentFiles() {
            int count = 0;
            for (StoreFileMetaData file : this) {
                if (!file.name().startsWith("segments")) continue;
                ++count;
            }
            return count;
        }

        public String getSyncId() {
            return this.commitUserData.get("sync_id");
        }

        static class LoadedMetadata {
            final Map<String, StoreFileMetaData> fileMetadata;
            final Map<String, String> userData;
            final long numDocs;

            LoadedMetadata(Map<String, StoreFileMetaData> fileMetadata, Map<String, String> userData, long numDocs) {
                this.fileMetadata = fileMetadata;
                this.userData = userData;
                this.numDocs = numDocs;
            }
        }
    }

    static final class StoreDirectory
    extends FilterDirectory {
        private final Logger deletesLogger;

        StoreDirectory(Directory delegateDirectory, Logger deletesLogger) throws IOException {
            super(delegateDirectory);
            this.deletesLogger = deletesLogger;
        }

        @Override
        public void close() throws IOException {
            assert (false) : "Nobody should close this directory except of the Store itself";
        }

        public void deleteFile(String msg, String name) throws IOException {
            this.deletesLogger.trace("{}: delete file {}", (Object)msg, (Object)name);
            super.deleteFile(name);
        }

        @Override
        public void deleteFile(String name) throws IOException {
            this.deleteFile("StoreDirectory.deleteFile", name);
        }

        private void innerClose() throws IOException {
            super.close();
        }

        @Override
        public String toString() {
            return "store(" + this.in.toString() + ")";
        }
    }
}

