/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.StoredField;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.TypeParsers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardException;

public class SourceFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_source";
    public static final String CONTENT_TYPE = "_source";
    private final Function<Map<String, ?>, Map<String, Object>> filter;
    private final boolean enabled;
    private final boolean complete;
    private final String[] includes;
    private final String[] excludes;

    private SourceFieldMapper(Settings indexSettings) {
        this(true, null, null, indexSettings);
    }

    private SourceFieldMapper(boolean enabled, String[] includes, String[] excludes, Settings indexSettings) {
        super("_source", Defaults.FIELD_TYPE.clone(), Defaults.FIELD_TYPE, indexSettings);
        this.enabled = enabled;
        this.includes = includes;
        this.excludes = excludes;
        boolean filtered = includes != null && includes.length > 0 || excludes != null && excludes.length > 0;
        this.filter = enabled && filtered && this.fieldType().stored() ? XContentMapValues.filter(includes, excludes) : null;
        this.complete = enabled && includes == null && excludes == null;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String[] excludes() {
        return this.excludes != null ? this.excludes : Strings.EMPTY_ARRAY;
    }

    public String[] includes() {
        return this.includes != null ? this.includes : Strings.EMPTY_ARRAY;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        BytesReference source = context.sourceToParse().source();
        if (this.enabled && this.fieldType().stored() && source != null) {
            if (this.filter != null) {
                Tuple<XContentType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(source, true, context.sourceToParse().getXContentType());
                Map<String, Object> filteredSource = this.filter.apply(mapTuple.v2());
                BytesStreamOutput bStream = new BytesStreamOutput();
                XContentType contentType = mapTuple.v1();
                XContentBuilder builder = XContentFactory.contentBuilder(contentType, bStream).map(filteredSource);
                builder.close();
                source = bStream.bytes();
            }
            BytesRef ref = source.toBytesRef();
            fields.add(new StoredField(this.fieldType().name(), ref.bytes, ref.offset, ref.length));
        }
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabled && this.includes == null && this.excludes == null) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (includeDefaults || !this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.includes != null) {
            builder.array("includes", this.includes);
        } else if (includeDefaults) {
            builder.array("includes", Strings.EMPTY_ARRAY);
        }
        if (this.excludes != null) {
            builder.array("excludes", this.excludes);
        } else if (includeDefaults) {
            builder.array("excludes", Strings.EMPTY_ARRAY);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        SourceFieldMapper sourceMergeWith = (SourceFieldMapper)mergeWith;
        ArrayList<String> conflicts = new ArrayList<String>();
        if (this.enabled != sourceMergeWith.enabled) {
            conflicts.add("Cannot update enabled setting for [_source]");
        }
        if (!Arrays.equals(this.includes(), sourceMergeWith.includes())) {
            conflicts.add("Cannot update includes setting for [_source]");
        }
        if (!Arrays.equals(this.excludes(), sourceMergeWith.excludes())) {
            conflicts.add("Cannot update excludes setting for [_source]");
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalArgumentException("Can't merge because of conflicts: " + conflicts);
        }
    }

    static final class SourceFieldType
    extends MappedFieldType {
        SourceFieldType() {
        }

        protected SourceFieldType(SourceFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new SourceFieldType(this);
        }

        @Override
        public String typeName() {
            return "_source";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new QueryShardException(context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "The _source field is not searchable", new Object[0]);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                int i;
                List values;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(TypeParsers.nodeBooleanValue(name, "enabled", fieldNode, parserContext));
                    iterator.remove();
                    continue;
                }
                if ("format".equals(fieldName) && parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha1)) {
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("includes")) {
                    values = (List)fieldNode;
                    String[] includes = new String[values.size()];
                    for (i = 0; i < includes.length; ++i) {
                        includes[i] = values.get(i).toString();
                    }
                    builder.includes(includes);
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("excludes")) continue;
                values = (List)fieldNode;
                String[] excludes = new String[values.size()];
                for (i = 0; i < excludes.length; ++i) {
                    excludes[i] = values.get(i).toString();
                }
                builder.excludes(excludes);
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new SourceFieldMapper(indexSettings);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, SourceFieldMapper> {
        private boolean enabled = true;
        private String[] includes = null;
        private String[] excludes = null;

        public Builder() {
            super("_source", Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder includes(String[] includes) {
            this.includes = includes;
            return this;
        }

        public Builder excludes(String[] excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        public SourceFieldMapper build(Mapper.BuilderContext context) {
            return new SourceFieldMapper(this.enabled, this.includes, this.excludes, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_source";
        public static final boolean ENABLED = true;
        public static final MappedFieldType FIELD_TYPE = new SourceFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_source");
            FIELD_TYPE.freeze();
        }
    }
}

