/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.Snapshot;

public abstract class RecoverySource
implements Writeable,
ToXContentObject {
    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", (Object)this.getType());
        this.addAdditionalFields(builder, params);
        return builder.endObject();
    }

    public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static RecoverySource readFrom(StreamInput in) throws IOException {
        Type type = Type.values()[in.readByte()];
        switch (type) {
            case EMPTY_STORE: {
                return StoreRecoverySource.EMPTY_STORE_INSTANCE;
            }
            case EXISTING_STORE: {
                return StoreRecoverySource.EXISTING_STORE_INSTANCE;
            }
            case PEER: {
                return PeerRecoverySource.INSTANCE;
            }
            case SNAPSHOT: {
                return new SnapshotRecoverySource(in);
            }
            case LOCAL_SHARDS: {
                return LocalShardsRecoverySource.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unknown recovery type: " + type.name());
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeByte((byte)this.getType().ordinal());
        this.writeAdditionalFields(out);
    }

    protected void writeAdditionalFields(StreamOutput out) throws IOException {
    }

    public abstract Type getType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoverySource that = (RecoverySource)o;
        return this.getType() == that.getType();
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public static class PeerRecoverySource
    extends RecoverySource {
        public static final PeerRecoverySource INSTANCE = new PeerRecoverySource();

        private PeerRecoverySource() {
        }

        @Override
        public Type getType() {
            return Type.PEER;
        }

        public String toString() {
            return "peer recovery";
        }
    }

    public static class SnapshotRecoverySource
    extends RecoverySource {
        private final Snapshot snapshot;
        private final String index;
        private final Version version;

        public SnapshotRecoverySource(Snapshot snapshot, Version version, String index) {
            this.snapshot = Objects.requireNonNull(snapshot);
            this.version = Objects.requireNonNull(version);
            this.index = Objects.requireNonNull(index);
        }

        SnapshotRecoverySource(StreamInput in) throws IOException {
            this.snapshot = new Snapshot(in);
            this.version = Version.readVersion(in);
            this.index = in.readString();
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public String index() {
            return this.index;
        }

        public Version version() {
            return this.version;
        }

        @Override
        protected void writeAdditionalFields(StreamOutput out) throws IOException {
            this.snapshot.writeTo(out);
            Version.writeVersion(this.version, out);
            out.writeString(this.index);
        }

        @Override
        public Type getType() {
            return Type.SNAPSHOT;
        }

        @Override
        public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("repository", this.snapshot.getRepository()).field("snapshot", this.snapshot.getSnapshotId().getName()).field("version", this.version.toString()).field("index", this.index);
        }

        public String toString() {
            return "snapshot recovery from " + this.snapshot.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotRecoverySource that = (SnapshotRecoverySource)o;
            return this.snapshot.equals(that.snapshot) && this.index.equals(that.index) && this.version.equals(that.version);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.snapshot, this.index, this.version);
        }
    }

    public static class LocalShardsRecoverySource
    extends RecoverySource {
        public static final LocalShardsRecoverySource INSTANCE = new LocalShardsRecoverySource();

        private LocalShardsRecoverySource() {
        }

        @Override
        public Type getType() {
            return Type.LOCAL_SHARDS;
        }

        public String toString() {
            return "local shards recovery";
        }
    }

    public static abstract class StoreRecoverySource
    extends RecoverySource {
        public static final StoreRecoverySource EMPTY_STORE_INSTANCE = new StoreRecoverySource(){

            @Override
            public Type getType() {
                return Type.EMPTY_STORE;
            }
        };
        public static final StoreRecoverySource EXISTING_STORE_INSTANCE = new StoreRecoverySource(){

            @Override
            public Type getType() {
                return Type.EXISTING_STORE;
            }
        };

        public String toString() {
            return this.getType() == Type.EMPTY_STORE ? "new shard recovery" : "existing recovery";
        }
    }

    public static enum Type {
        EMPTY_STORE,
        EXISTING_STORE,
        PEER,
        SNAPSHOT,
        LOCAL_SHARDS;

    }
}

