/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulateDocumentBaseResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulateDocumentVerboseResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class SimulatePipelineResponse
extends ActionResponse
implements ToXContentObject {
    private String pipelineId;
    private boolean verbose;
    private List<SimulateDocumentResult> results;

    public SimulatePipelineResponse() {
    }

    public SimulatePipelineResponse(String pipelineId, boolean verbose, List<SimulateDocumentResult> responses) {
        this.pipelineId = pipelineId;
        this.verbose = verbose;
        this.results = Collections.unmodifiableList(responses);
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public List<SimulateDocumentResult> getResults() {
        return this.results;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.pipelineId);
        out.writeBoolean(this.verbose);
        out.writeVInt(this.results.size());
        for (SimulateDocumentResult response : this.results) {
            response.writeTo(out);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.pipelineId = in.readOptionalString();
        boolean verbose = in.readBoolean();
        int responsesLength = in.readVInt();
        this.results = new ArrayList<SimulateDocumentResult>();
        for (int i = 0; i < responsesLength; ++i) {
            SimulateDocumentResult simulateDocumentResult = verbose ? new SimulateDocumentVerboseResult(in) : new SimulateDocumentBaseResult(in);
            this.results.add(simulateDocumentResult);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("docs");
        for (SimulateDocumentResult response : this.results) {
            response.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String DOCUMENTS = "docs";

        Fields() {
        }
    }
}

