/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class ValidateQueryResponse
extends BroadcastResponse {
    public static final String INDEX_FIELD = "index";
    public static final String SHARD_FIELD = "shard";
    public static final String VALID_FIELD = "valid";
    public static final String EXPLANATIONS_FIELD = "explanations";
    public static final String ERROR_FIELD = "error";
    public static final String EXPLANATION_FIELD = "explanation";
    private boolean valid;
    private List<QueryExplanation> queryExplanations;

    ValidateQueryResponse() {
    }

    ValidateQueryResponse(boolean valid, List<QueryExplanation> queryExplanations, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.valid = valid;
        this.queryExplanations = queryExplanations;
        if (queryExplanations == null) {
            this.queryExplanations = Collections.emptyList();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<? extends QueryExplanation> getQueryExplanation() {
        if (this.queryExplanations == null) {
            return Collections.emptyList();
        }
        return this.queryExplanations;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.valid = in.readBoolean();
        int size = in.readVInt();
        if (size > 0) {
            this.queryExplanations = new ArrayList<QueryExplanation>(size);
            for (int i = 0; i < size; ++i) {
                this.queryExplanations.add(QueryExplanation.readQueryExplanation(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.valid);
        out.writeVInt(this.queryExplanations.size());
        for (QueryExplanation exp : this.queryExplanations) {
            exp.writeTo(out);
        }
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(VALID_FIELD, this.isValid());
        if (this.getQueryExplanation() != null && !this.getQueryExplanation().isEmpty()) {
            builder.startArray(EXPLANATIONS_FIELD);
            for (QueryExplanation queryExplanation : this.getQueryExplanation()) {
                builder.startObject();
                if (queryExplanation.getIndex() != null) {
                    builder.field(INDEX_FIELD, queryExplanation.getIndex());
                }
                if (queryExplanation.getShard() >= 0) {
                    builder.field(SHARD_FIELD, queryExplanation.getShard());
                }
                builder.field(VALID_FIELD, queryExplanation.isValid());
                if (queryExplanation.getError() != null) {
                    builder.field(ERROR_FIELD, queryExplanation.getError());
                }
                if (queryExplanation.getExplanation() != null) {
                    builder.field(EXPLANATION_FIELD, queryExplanation.getExplanation());
                }
                builder.endObject();
            }
            builder.endArray();
        }
    }
}

