/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class SnapshotShardsStats
implements ToXContentFragment {
    private int initializingShards;
    private int startedShards;
    private int finalizingShards;
    private int doneShards;
    private int failedShards;
    private int totalShards;

    SnapshotShardsStats(Collection<SnapshotIndexShardStatus> shards) {
        block7: for (SnapshotIndexShardStatus shard : shards) {
            ++this.totalShards;
            switch (shard.getStage()) {
                case INIT: {
                    ++this.initializingShards;
                    continue block7;
                }
                case STARTED: {
                    ++this.startedShards;
                    continue block7;
                }
                case FINALIZE: {
                    ++this.finalizingShards;
                    continue block7;
                }
                case DONE: {
                    ++this.doneShards;
                    continue block7;
                }
                case FAILURE: {
                    ++this.failedShards;
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unknown stage type " + (Object)((Object)shard.getStage()));
        }
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getStartedShards() {
        return this.startedShards;
    }

    public int getFinalizingShards() {
        return this.finalizingShards;
    }

    public int getDoneShards() {
        return this.doneShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("shards_stats");
        builder.field("initializing", this.getInitializingShards());
        builder.field("started", this.getStartedShards());
        builder.field("finalizing", this.getFinalizingShards());
        builder.field("done", this.getDoneShards());
        builder.field("failed", this.getFailedShards());
        builder.field("total", this.getTotalShards());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String SHARDS_STATS = "shards_stats";
        static final String INITIALIZING = "initializing";
        static final String STARTED = "started";
        static final String FINALIZING = "finalizing";
        static final String DONE = "done";
        static final String FAILED = "failed";
        static final String TOTAL = "total";

        Fields() {
        }
    }
}

