/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.settings;

import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlocks;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

final class SettingsUpdater {
    final Settings.Builder transientUpdates = Settings.builder();
    final Settings.Builder persistentUpdates = Settings.builder();
    private final ClusterSettings clusterSettings;

    SettingsUpdater(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
    }

    synchronized Settings getTransientUpdates() {
        return this.transientUpdates.build();
    }

    synchronized Settings getPersistentUpdate() {
        return this.persistentUpdates.build();
    }

    synchronized ClusterState updateSettings(ClusterState currentState, Settings transientToApply, Settings persistentToApply, Logger logger) {
        ClusterState clusterState;
        boolean changed = false;
        Tuple<Settings, Settings> partitionedTransientSettings = this.partitionKnownAndValidSettings(currentState.metaData().transientSettings(), "transient", logger);
        Settings knownAndValidTransientSettings = partitionedTransientSettings.v1();
        Settings unknownOrInvalidTransientSettings = partitionedTransientSettings.v2();
        Settings.Builder transientSettings = Settings.builder().put(knownAndValidTransientSettings);
        changed |= this.clusterSettings.updateDynamicSettings(transientToApply, transientSettings, this.transientUpdates, "transient");
        Tuple<Settings, Settings> partitionedPersistentSettings = this.partitionKnownAndValidSettings(currentState.metaData().persistentSettings(), "persistent", logger);
        Settings knownAndValidPersistentSettings = partitionedPersistentSettings.v1();
        Settings unknownOrInvalidPersistentSettings = partitionedPersistentSettings.v2();
        Settings.Builder persistentSettings = Settings.builder().put(knownAndValidPersistentSettings);
        if (changed |= this.clusterSettings.updateDynamicSettings(persistentToApply, persistentSettings, this.persistentUpdates, "persistent")) {
            boolean updatedReadOnlyAllowDelete;
            boolean updatedReadOnly;
            Settings transientFinalSettings = transientSettings.build();
            Settings persistentFinalSettings = persistentSettings.build();
            this.clusterSettings.validate(transientFinalSettings, true);
            this.clusterSettings.validate(persistentFinalSettings, true);
            MetaData.Builder metaData = MetaData.builder(currentState.metaData()).transientSettings(Settings.builder().put(transientFinalSettings).put(unknownOrInvalidTransientSettings).build()).persistentSettings(Settings.builder().put(persistentFinalSettings).put(unknownOrInvalidPersistentSettings).build());
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            boolean bl = updatedReadOnly = MetaData.SETTING_READ_ONLY_SETTING.get(metaData.persistentSettings()) != false || MetaData.SETTING_READ_ONLY_SETTING.get(metaData.transientSettings()) != false;
            if (updatedReadOnly) {
                blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
            } else {
                blocks.removeGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
            }
            boolean bl2 = updatedReadOnlyAllowDelete = MetaData.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(metaData.persistentSettings()) != false || MetaData.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(metaData.transientSettings()) != false;
            if (updatedReadOnlyAllowDelete) {
                blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
            } else {
                blocks.removeGlobalBlock(MetaData.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
            }
            clusterState = ClusterState.builder(currentState).metaData(metaData).blocks(blocks).build();
        } else {
            clusterState = currentState;
        }
        Settings settings = clusterState.metaData().settings();
        this.clusterSettings.validateUpdate(settings);
        return clusterState;
    }

    private Tuple<Settings, Settings> partitionKnownAndValidSettings(Settings settings, String settingsType, Logger logger) {
        Settings existingArchivedSettings = settings.filter(k -> k.startsWith("archived."));
        Settings settingsExcludingExistingArchivedSettings = settings.filter(k -> !k.startsWith("archived."));
        Settings settingsWithUnknownOrInvalidArchived = this.clusterSettings.archiveUnknownOrInvalidSettings(settingsExcludingExistingArchivedSettings, e -> this.logUnknownSetting(settingsType, (Map.Entry<String, String>)e, logger), (e, ex) -> this.logInvalidSetting(settingsType, (Map.Entry<String, String>)e, (IllegalArgumentException)ex, logger));
        return Tuple.tuple(Settings.builder().put(settingsWithUnknownOrInvalidArchived.filter(k -> !k.startsWith("archived."))).put(existingArchivedSettings).build(), settingsWithUnknownOrInvalidArchived.filter(k -> k.startsWith("archived.")));
    }

    private void logUnknownSetting(String settingType, Map.Entry<String, String> e, Logger logger) {
        logger.warn("ignoring existing unknown {} setting: [{}] with value [{}]; archiving", (Object)settingType, (Object)e.getKey(), (Object)e.getValue());
    }

    private void logInvalidSetting(String settingType, Map.Entry<String, String> e, IllegalArgumentException ex, Logger logger) {
        logger.warn(() -> new ParameterizedMessage("ignoring existing invalid {} setting: [{}] with value [{}]; archiving", new Object[]{settingType, e.getKey(), e.getValue()}), (Throwable)ex);
    }
}

