/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.BasePlanetObject;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.Plane;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.Vector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.XYZSolid;

abstract class BaseXYZSolid
extends BasePlanetObject
implements XYZSolid {
    protected static final Vector xUnitVector = new Vector(1.0, 0.0, 0.0);
    protected static final Vector yUnitVector = new Vector(0.0, 1.0, 0.0);
    protected static final Vector zUnitVector = new Vector(0.0, 0.0, 1.0);
    protected static final Plane xVerticalPlane = new Plane(0.0, 1.0, 0.0, 0.0);
    protected static final Plane yVerticalPlane = new Plane(1.0, 0.0, 0.0, 0.0);
    protected static final GeoPoint[] EMPTY_POINTS = new GeoPoint[0];
    protected static final int ALL_INSIDE = 0;
    protected static final int SOME_INSIDE = 1;
    protected static final int NONE_INSIDE = 2;
    protected static final int NO_EDGEPOINTS = 3;

    public BaseXYZSolid(PlanetModel planetModel) {
        super(planetModel);
    }

    protected static GeoPoint[] glueTogether(GeoPoint[] ... pointArrays) {
        int count = 0;
        for (GeoPoint[] pointArray : pointArrays) {
            count += pointArray.length;
        }
        GeoPoint[] rval = new GeoPoint[count];
        count = 0;
        GeoPoint[][] geoPointArray = pointArrays;
        int n = geoPointArray.length;
        for (int i = 0; i < n; ++i) {
            GeoPoint[] pointArray;
            for (GeoPoint point : pointArray = geoPointArray[i]) {
                rval[count++] = point;
            }
        }
        return rval;
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.isWithin(point.x, point.y, point.z);
    }

    @Override
    public abstract boolean isWithin(double var1, double var3, double var5);

    protected int isShapeInsideArea(GeoShape path) {
        GeoPoint[] pathPoints = path.getEdgePoints();
        if (pathPoints.length == 0) {
            return 3;
        }
        boolean foundOutside = false;
        boolean foundInside = false;
        for (GeoPoint p : pathPoints) {
            if (this.isWithin(p)) {
                foundInside = true;
            } else {
                foundOutside = true;
            }
            if (!foundInside || !foundOutside) continue;
            return 1;
        }
        if (!foundInside && !foundOutside) {
            return 2;
        }
        if (foundInside && !foundOutside) {
            return 0;
        }
        if (foundOutside && !foundInside) {
            return 2;
        }
        return 1;
    }

    protected int isAreaInsideShape(GeoShape path) {
        GeoPoint[] edgePoints = this.getEdgePoints();
        if (edgePoints.length == 0) {
            return 3;
        }
        boolean foundOutside = false;
        boolean foundInside = false;
        for (GeoPoint p : edgePoints) {
            if (path.isWithin(p)) {
                foundInside = true;
            } else {
                foundOutside = true;
            }
            if (!foundInside || !foundOutside) continue;
            return 1;
        }
        if (!foundInside && !foundOutside) {
            return 2;
        }
        if (foundInside && !foundOutside) {
            return 0;
        }
        if (foundOutside && !foundInside) {
            return 2;
        }
        return 1;
    }

    protected abstract GeoPoint[] getEdgePoints();

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BaseXYZSolid)) {
            return false;
        }
        BaseXYZSolid other = (BaseXYZSolid)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

