/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.util;

public class GeoRelationUtils {
    private GeoRelationUtils() {
    }

    public static boolean pointInRectPrecise(double lat, double lon, double minLat, double maxLat, double minLon, double maxLon) {
        return lat >= minLat && lat <= maxLat && lon >= minLon && lon <= maxLon;
    }

    private static boolean rectDisjoint(double aMinLat, double aMaxLat, double aMinLon, double aMaxLon, double bMinLat, double bMaxLat, double bMinLon, double bMaxLon) {
        return aMaxLon < bMinLon || aMinLon > bMaxLon || aMaxLat < bMinLat || aMinLat > bMaxLat;
    }

    public static boolean rectWithin(double aMinLat, double aMaxLat, double aMinLon, double aMaxLon, double bMinLat, double bMaxLat, double bMinLon, double bMaxLon) {
        return !(aMinLon < bMinLon || aMinLat < bMinLat || aMaxLon > bMaxLon || aMaxLat > bMaxLat);
    }

    public static boolean rectCrosses(double aMinLat, double aMaxLat, double aMinLon, double aMaxLon, double bMinLat, double bMaxLat, double bMinLon, double bMaxLon) {
        return !GeoRelationUtils.rectDisjoint(aMinLat, aMaxLat, aMinLon, aMaxLon, bMinLat, bMaxLat, bMinLon, bMaxLon) && !GeoRelationUtils.rectWithin(aMinLat, aMaxLat, aMinLon, aMaxLon, bMinLat, bMaxLat, bMinLon, bMaxLon);
    }

    public static boolean rectIntersects(double aMinLat, double aMaxLat, double aMinLon, double aMaxLon, double bMinLat, double bMaxLat, double bMinLon, double bMaxLon) {
        return !(aMaxLon < bMinLon || aMinLon > bMaxLon || aMaxLat < bMinLat || aMinLat > bMaxLat);
    }
}

