/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree;

import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Projections;
import java.util.ArrayList;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.FilterCellIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.S2PrefixTreeCell;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.S2ShapeFactory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class S2PrefixTree
extends SpatialPrefixTree {
    protected final S2ShapeFactory s2ShapeFactory;
    protected final int arity;

    public S2PrefixTree(SpatialContext ctx, int maxLevels) {
        this(ctx, maxLevels, 1);
    }

    public S2PrefixTree(SpatialContext ctx, int maxLevels, int arity) {
        super(ctx, maxLevels);
        if (!(ctx.getShapeFactory() instanceof S2ShapeFactory)) {
            throw new IllegalArgumentException("Spatial context does not support S2 spatial index.");
        }
        this.s2ShapeFactory = (S2ShapeFactory)ctx.getShapeFactory();
        if (arity < 1 || arity > 3) {
            throw new IllegalArgumentException("Invalid value for S2 tree arity. Possible values are 1, 2 or 3. Provided value is " + arity + ".");
        }
        this.arity = arity;
    }

    public static int getMaxLevels(int arity) {
        return 30 / arity + 1;
    }

    @Override
    public int getLevelForDistance(double dist) {
        if (dist == 0.0) {
            return this.maxLevels;
        }
        int level = S2Projections.MAX_WIDTH.getMinLevel(dist * (Math.PI / 180));
        int roundLevel = level % this.arity != 0 ? 1 : 0;
        level = level / this.arity + roundLevel;
        return Math.min(this.maxLevels, level + 1);
    }

    @Override
    public double getDistanceForLevel(int level) {
        if (level == 0) {
            return 180.0;
        }
        return S2Projections.MAX_WIDTH.getValue(this.arity * (level - 1)) * 57.29577951308232;
    }

    @Override
    public Cell getWorldCell() {
        return new S2PrefixTreeCell(this, null);
    }

    @Override
    public Cell readCell(BytesRef term, Cell scratch) {
        S2PrefixTreeCell cell = (S2PrefixTreeCell)scratch;
        if (cell == null) {
            cell = (S2PrefixTreeCell)this.getWorldCell();
        }
        cell.readCell(this, term);
        return cell;
    }

    @Override
    public CellIterator getTreeCellIterator(Shape shape, int detailLevel) {
        if (!(shape instanceof Point)) {
            return super.getTreeCellIterator(shape, detailLevel);
        }
        Point p = (Point)shape;
        S2CellId id = S2CellId.fromLatLng((S2LatLng)S2LatLng.fromDegrees((double)p.getY(), (double)p.getX())).parent(this.arity * (detailLevel - 1));
        ArrayList<S2PrefixTreeCell> cells = new ArrayList<S2PrefixTreeCell>(detailLevel);
        for (int i = 0; i < detailLevel - 1; ++i) {
            cells.add(new S2PrefixTreeCell(this, id.parent(i * this.arity)));
        }
        cells.add(new S2PrefixTreeCell(this, id));
        return new FilterCellIterator(cells.iterator(), null);
    }

    protected static class Factory
    extends SpatialPrefixTreeFactory {
        protected Factory() {
        }

        @Override
        protected int getLevelForDistance(double degrees) {
            S2PrefixTree grid = new S2PrefixTree(this.ctx, S2PrefixTree.getMaxLevels(1));
            return grid.getLevelForDistance(degrees);
        }

        @Override
        protected SpatialPrefixTree newSPT() {
            return new S2PrefixTree(this.ctx, this.maxLevels != null ? this.maxLevels : S2PrefixTree.getMaxLevels(1));
        }
    }
}

