/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.uhighlight;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class SplittingBreakIterator
extends BreakIterator {
    private final BreakIterator baseIter;
    private final char sliceChar;
    private String text;
    private int sliceStartIdx;
    private int sliceEndIdx;
    private int current;

    public SplittingBreakIterator(BreakIterator baseIter, char sliceChar) {
        this.baseIter = baseIter;
        this.sliceChar = sliceChar;
    }

    @Override
    public void setText(CharacterIterator newText) {
        throw new UnsupportedOperationException("unexpected");
    }

    @Override
    public void setText(String newText) {
        this.text = newText;
        this.first();
    }

    @Override
    public CharacterIterator getText() {
        StringCharacterIterator charIter = new StringCharacterIterator(this.text);
        charIter.setIndex(this.current());
        return charIter;
    }

    @Override
    public int current() {
        assert (this.current != -1);
        return this.current;
    }

    @Override
    public int first() {
        this.sliceStartIdx = 0;
        this.sliceEndIdx = this.text.indexOf(this.sliceChar);
        if (this.sliceEndIdx == -1) {
            this.sliceEndIdx = this.text.length();
        }
        if (this.sliceStartIdx == this.sliceEndIdx) {
            this.current = this.sliceStartIdx;
            return this.current;
        }
        this.baseIter.setText(this.text.substring(this.sliceStartIdx, this.sliceEndIdx));
        this.current = this.sliceStartIdx + this.baseIter.current();
        return this.current;
    }

    @Override
    public int last() {
        this.sliceEndIdx = this.text.length();
        this.sliceStartIdx = this.text.lastIndexOf(this.sliceChar);
        this.sliceStartIdx = this.sliceStartIdx == -1 ? 0 : ++this.sliceStartIdx;
        if (this.sliceEndIdx == this.sliceStartIdx) {
            this.current = this.sliceEndIdx;
            return this.current;
        }
        this.baseIter.setText(this.text.substring(this.sliceStartIdx, this.sliceEndIdx));
        this.current = this.sliceStartIdx + this.baseIter.last();
        return this.current;
    }

    @Override
    public int next() {
        int prevCurrent = this.current;
        int n = this.current = this.sliceStartIdx == this.sliceEndIdx ? -1 : this.baseIter.next();
        if (this.current != -1) {
            return this.current += this.sliceStartIdx;
        }
        if (this.sliceEndIdx >= this.text.length()) {
            this.current = prevCurrent;
            return -1;
        }
        this.sliceStartIdx = this.sliceEndIdx + 1;
        this.sliceEndIdx = this.text.indexOf(this.sliceChar, this.sliceStartIdx);
        if (this.sliceEndIdx == -1) {
            this.sliceEndIdx = this.text.length();
        }
        if (this.sliceStartIdx == this.sliceEndIdx) {
            this.current = this.sliceStartIdx;
            return this.current;
        }
        this.baseIter.setText(this.text.substring(this.sliceStartIdx, this.sliceEndIdx));
        this.current = this.sliceStartIdx + this.baseIter.current();
        return this.current;
    }

    @Override
    public int previous() {
        int prevCurrent = this.current;
        int n = this.current = this.sliceStartIdx == this.sliceEndIdx ? -1 : this.baseIter.previous();
        if (this.current != -1) {
            return this.current += this.sliceStartIdx;
        }
        if (this.sliceStartIdx == 0) {
            this.current = prevCurrent;
            return -1;
        }
        this.sliceEndIdx = this.sliceStartIdx - 1;
        this.sliceStartIdx = this.text.lastIndexOf(this.sliceChar, this.sliceEndIdx - 1);
        this.sliceStartIdx = this.sliceStartIdx == -1 ? 0 : ++this.sliceStartIdx;
        if (this.sliceStartIdx == this.sliceEndIdx) {
            this.current = this.sliceStartIdx;
            return this.current;
        }
        this.baseIter.setText(this.text.substring(this.sliceStartIdx, this.sliceEndIdx));
        this.current = this.sliceStartIdx + this.baseIter.last();
        return this.current;
    }

    @Override
    public int following(int offset) {
        if (offset + 1 < this.sliceStartIdx || offset + 1 > this.sliceEndIdx) {
            if (offset == this.text.length()) {
                this.last();
                return -1;
            }
            this.sliceStartIdx = this.text.lastIndexOf(this.sliceChar, offset);
            this.sliceStartIdx = this.sliceStartIdx == -1 ? 0 : ++this.sliceStartIdx;
            this.sliceEndIdx = this.text.indexOf(this.sliceChar, Math.max(offset + 1, this.sliceStartIdx));
            if (this.sliceEndIdx == -1) {
                this.sliceEndIdx = this.text.length();
            }
            if (this.sliceStartIdx != this.sliceEndIdx) {
                this.baseIter.setText(this.text.substring(this.sliceStartIdx, this.sliceEndIdx));
            }
        }
        if (this.sliceStartIdx == this.sliceEndIdx) {
            this.current = offset + 1;
            return this.current;
        }
        if (offset == this.sliceStartIdx - 1) {
            this.current = this.sliceStartIdx + this.baseIter.first();
            return this.current;
        }
        this.current = this.sliceStartIdx + this.baseIter.following(offset - this.sliceStartIdx);
        return this.current;
    }

    @Override
    public int preceding(int offset) {
        if (offset - 1 < this.sliceStartIdx || offset - 1 > this.sliceEndIdx) {
            if (offset == 0) {
                this.first();
                return -1;
            }
            this.sliceEndIdx = this.text.indexOf(this.sliceChar, offset);
            if (this.sliceEndIdx == -1) {
                this.sliceEndIdx = this.text.length();
            }
            this.sliceStartIdx = this.text.lastIndexOf(this.sliceChar, offset - 1);
            this.sliceStartIdx = this.sliceStartIdx == -1 ? 0 : Math.min(this.sliceStartIdx + 1, this.sliceEndIdx);
            if (this.sliceStartIdx != this.sliceEndIdx) {
                this.baseIter.setText(this.text.substring(this.sliceStartIdx, this.sliceEndIdx));
            }
        }
        if (this.sliceStartIdx == this.sliceEndIdx) {
            this.current = offset - 1;
            return this.current;
        }
        if (offset == this.sliceEndIdx + 1) {
            this.current = this.sliceStartIdx + this.baseIter.last();
            return this.current;
        }
        this.current = this.sliceStartIdx + this.baseIter.preceding(offset - this.sliceStartIdx);
        return this.current;
    }

    @Override
    public int next(int n) {
        if (n < 0) {
            for (int i = 0; i < -n; ++i) {
                if (this.previous() != -1) continue;
                return -1;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (this.next() != -1) continue;
                return -1;
            }
        }
        return this.current();
    }
}

