/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.LatLonPoint;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.geo.GeoUtils;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.geo.Rectangle;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.PointValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ConstantScoreScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ConstantScoreWeight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ScorerSupplier;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BitSetIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.DocIdSetBuilder;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.NumericUtils;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.StringHelper;

final class LatLonPointDistanceQuery
extends Query {
    final String field;
    final double latitude;
    final double longitude;
    final double radiusMeters;

    public LatLonPointDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("radiusMeters: '" + radiusMeters + "' is invalid");
        }
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        Rectangle box = Rectangle.fromPointDistance(this.latitude, this.longitude, this.radiusMeters);
        final byte[] minLat = new byte[4];
        final byte[] maxLat = new byte[4];
        final byte[] minLon = new byte[4];
        final byte[] maxLon = new byte[4];
        final byte[] minLon2 = new byte[4];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(box.minLat), minLat, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(box.maxLat), maxLat, 0);
        if (box.crossesDateline()) {
            NumericUtils.intToSortableBytes(Integer.MIN_VALUE, minLon, 0);
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.maxLon), maxLon, 0);
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.minLon), minLon2, 0);
        } else {
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.minLon), minLon, 0);
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.maxLon), maxLon, 0);
            NumericUtils.intToSortableBytes(Integer.MAX_VALUE, minLon2, 0);
        }
        final double sortKey = GeoUtils.distanceQuerySortKey(this.radiusMeters);
        final double axisLat = Rectangle.axisLat(this.latitude, this.radiusMeters);
        return new ConstantScoreWeight(this, boost){
            final GeoEncodingUtils.DistancePredicate distancePredicate;
            {
                super(x0, x1);
                this.distancePredicate = GeoEncodingUtils.createDistancePredicate(LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, LatLonPointDistanceQuery.this.radiusMeters);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(LatLonPointDistanceQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointDistanceQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc(), values, LatLonPointDistanceQuery.this.field);
                final PointValues.IntersectVisitor visitor = this.getIntersectVisitor(result);
                final 1 weight = this;
                return new ScorerSupplier(){
                    long cost = -1L;

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        if (values.getDocCount() == reader.maxDoc() && (long)values.getDocCount() == values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                            FixedBitSet result2 = new FixedBitSet(reader.maxDoc());
                            result2.set(0, reader.maxDoc());
                            int[] cost = new int[]{reader.maxDoc()};
                            values.intersect(this.getInverseIntersectVisitor(result2, cost));
                            BitSetIterator iterator = new BitSetIterator(result2, cost[0]);
                            return new ConstantScoreScorer(weight, this.score(), iterator);
                        }
                        values.intersect(visitor);
                        return new ConstantScoreScorer(weight, this.score(), result.build().iterator());
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimatePointCount(visitor);
                        }
                        assert (this.cost >= 0L);
                        return this.cost;
                    }
                };
            }

            private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        int docLongitude;
                        if (StringHelper.compare(4, packedValue, 0, maxLat, 0) > 0 || StringHelper.compare(4, packedValue, 0, minLat, 0) < 0) {
                            return;
                        }
                        if ((StringHelper.compare(4, packedValue, 4, maxLon, 0) > 0 || StringHelper.compare(4, packedValue, 4, minLon, 0) < 0) && StringHelper.compare(4, packedValue, 4, minLon2, 0) < 0) {
                            return;
                        }
                        int docLatitude = NumericUtils.sortableBytesToInt(packedValue, 0);
                        if (distancePredicate.test(docLatitude, docLongitude = NumericUtils.sortableBytesToInt(packedValue, 4))) {
                            this.adder.add(docID);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        if (StringHelper.compare(4, minPackedValue, 0, maxLat, 0) > 0 || StringHelper.compare(4, maxPackedValue, 0, minLat, 0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        if ((StringHelper.compare(4, minPackedValue, 4, maxLon, 0) > 0 || StringHelper.compare(4, maxPackedValue, 4, minLon, 0) < 0) && StringHelper.compare(4, maxPackedValue, 4, minLon2, 0) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        double latMin = GeoEncodingUtils.decodeLatitude(minPackedValue, 0);
                        double lonMin = GeoEncodingUtils.decodeLongitude(minPackedValue, 4);
                        double latMax = GeoEncodingUtils.decodeLatitude(maxPackedValue, 0);
                        double lonMax = GeoEncodingUtils.decodeLongitude(maxPackedValue, 4);
                        return GeoUtils.relate(latMin, latMax, lonMin, lonMax, LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, sortKey, axisLat);
                    }
                };
            }

            private PointValues.IntersectVisitor getInverseIntersectVisitor(final FixedBitSet result, final int[] cost) {
                return new PointValues.IntersectVisitor(){

                    @Override
                    public void visit(int docID) {
                        result.clear(docID);
                        cost[0] = cost[0] - 1;
                    }

                    @Override
                    public void visit(int docID, byte[] packedValue) {
                        int docLongitude;
                        if (StringHelper.compare(4, packedValue, 0, maxLat, 0) > 0 || StringHelper.compare(4, packedValue, 0, minLat, 0) < 0) {
                            result.clear(docID);
                            cost[0] = cost[0] - 1;
                            return;
                        }
                        if ((StringHelper.compare(4, packedValue, 4, maxLon, 0) > 0 || StringHelper.compare(4, packedValue, 4, minLon, 0) < 0) && StringHelper.compare(4, packedValue, 4, minLon2, 0) < 0) {
                            result.clear(docID);
                            cost[0] = cost[0] - 1;
                            return;
                        }
                        int docLatitude = NumericUtils.sortableBytesToInt(packedValue, 0);
                        if (!distancePredicate.test(docLatitude, docLongitude = NumericUtils.sortableBytesToInt(packedValue, 4))) {
                            result.clear(docID);
                            cost[0] = cost[0] - 1;
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        if (StringHelper.compare(4, minPackedValue, 0, maxLat, 0) > 0 || StringHelper.compare(4, maxPackedValue, 0, minLat, 0) < 0) {
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                        if ((StringHelper.compare(4, minPackedValue, 4, maxLon, 0) > 0 || StringHelper.compare(4, maxPackedValue, 4, minLon, 0) < 0) && StringHelper.compare(4, maxPackedValue, 4, minLon2, 0) < 0) {
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                        double latMin = GeoEncodingUtils.decodeLatitude(minPackedValue, 0);
                        double lonMin = GeoEncodingUtils.decodeLongitude(minPackedValue, 4);
                        double latMax = GeoEncodingUtils.decodeLatitude(maxPackedValue, 0);
                        double lonMax = GeoEncodingUtils.decodeLongitude(maxPackedValue, 4);
                        PointValues.Relation relation = GeoUtils.relate(latMin, latMax, lonMin, lonMax, LatLonPointDistanceQuery.this.latitude, LatLonPointDistanceQuery.this.longitude, sortKey, axisLat);
                        switch (relation) {
                            case CELL_INSIDE_QUERY: {
                                return PointValues.Relation.CELL_OUTSIDE_QUERY;
                            }
                            case CELL_OUTSIDE_QUERY: {
                                return PointValues.Relation.CELL_INSIDE_QUERY;
                            }
                        }
                        return relation;
                    }
                };
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((LatLonPointDistanceQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(LatLonPointDistanceQuery other) {
        return this.field.equals(other.field) && Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(other.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude) && Double.doubleToLongBits(this.radiusMeters) == Double.doubleToLongBits(other.radiusMeters);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.latitude);
        sb.append(",");
        sb.append(this.longitude);
        sb.append(" +/- ");
        sb.append(this.radiusMeters);
        sb.append(" meters");
        return sb.toString();
    }
}

