/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.ngram;

import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.util.TokenFilterFactory;

public class NGramFilterFactory
extends TokenFilterFactory {
    private final int maxGramSize;
    private final int minGramSize;

    public NGramFilterFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.getInt(args, "minGramSize", 1);
        this.maxGramSize = this.getInt(args, "maxGramSize", 2);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenFilter create(TokenStream input) {
        return new NGramTokenFilter(input, this.minGramSize, this.maxGramSize);
    }
}

