/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.dataformat.smile;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.core.JsonParseException;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.core.format.InputAccessor;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.core.format.MatchStrength;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.core.io.IOContext;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import org.apache.flink.elasticsearch6.shaded.com.fasterxml.jackson.dataformat.smile.SmileParser;

public class SmileParserBootstrapper {
    protected final IOContext _context;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected final boolean _bufferRecyclable;
    protected int _inputProcessed;

    public SmileParserBootstrapper(IOContext ctxt, InputStream in) {
        this._context = ctxt;
        this._in = in;
        this._inputBuffer = ctxt.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public SmileParserBootstrapper(IOContext ctxt, byte[] inputBuffer, int inputStart, int inputLen) {
        this._context = ctxt;
        this._in = null;
        this._inputBuffer = inputBuffer;
        this._inputPtr = inputStart;
        this._inputEnd = inputStart + inputLen;
        this._inputProcessed = -inputStart;
        this._bufferRecyclable = false;
    }

    public SmileParser constructParser(int factoryFeatures, int generalParserFeatures, int smileFeatures, ObjectCodec codec, ByteQuadsCanonicalizer rootByteSymbols) throws IOException, JsonParseException {
        int count;
        ByteQuadsCanonicalizer can = rootByteSymbols.makeChild(factoryFeatures);
        int end = this._inputEnd;
        if (this._inputPtr < end && this._in != null && (count = this._in.read(this._inputBuffer, end, this._inputBuffer.length - end)) > 0) {
            this._inputEnd += count;
        }
        SmileParser p = new SmileParser(this._context, generalParserFeatures, smileFeatures, codec, can, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        boolean hadSig = false;
        if (this._inputPtr < this._inputEnd) {
            if (this._inputBuffer[this._inputPtr] == 58) {
                hadSig = p.handleSignature(true, true);
            }
        } else {
            return p;
        }
        if (!hadSig && SmileParser.Feature.REQUIRE_HEADER.enabledIn(smileFeatures)) {
            byte firstByte = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr] : (byte)0;
            String msg = firstByte == 123 || firstByte == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(firstByte & 0xFF) + ") -- rather, it starts with '" + (char)firstByte + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(firstByte & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
            throw new JsonParseException(p, msg);
        }
        return p;
    }

    public static MatchStrength hasSmileFormat(InputAccessor acc) throws IOException {
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b1 = acc.nextByte();
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b2 = acc.nextByte();
        if (b1 == 58) {
            if (b2 != 41) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            return acc.nextByte() == 10 ? MatchStrength.FULL_MATCH : MatchStrength.NO_MATCH;
        }
        if (b1 == -6) {
            if (b2 == 52) {
                return MatchStrength.SOLID_MATCH;
            }
            int ch = b2 & 0xFF;
            if (ch >= 128 && ch < 248) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.NO_MATCH;
        }
        if (b1 == -8) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (SmileParserBootstrapper.likelySmileValue(b2) || SmileParserBootstrapper.possibleSmileValue(b2, true)) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.NO_MATCH;
        }
        if (SmileParserBootstrapper.likelySmileValue(b1) || SmileParserBootstrapper.possibleSmileValue(b2, false)) {
            return MatchStrength.SOLID_MATCH;
        }
        return MatchStrength.NO_MATCH;
    }

    private static boolean likelySmileValue(byte b) {
        if (b == -32 || b == -28 || b == -24 || b == -8 || b == -6) {
            return true;
        }
        int ch = b & 0xFF;
        return ch >= 128 && ch <= 159;
    }

    private static boolean possibleSmileValue(byte b, boolean lenient) {
        int ch = b & 0xFF;
        if (ch >= 128) {
            return ch <= 224;
        }
        if (lenient) {
            if (ch >= 64) {
                return true;
            }
            if (ch > -32) {
                return ch < 44;
            }
        }
        return false;
    }
}

