/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionFuture;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.PlainActionFuture;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.ConnectTransportException;

public interface TcpChannel
extends Releasable {
    @Override
    public void close();

    public void addCloseListener(ActionListener<Void> var1);

    public void setSoLinger(int var1) throws IOException;

    public boolean isOpen();

    public InetSocketAddress getLocalAddress();

    public void sendMessage(BytesReference var1, ActionListener<Void> var2);

    public static <C extends TcpChannel> void closeChannel(C channel, boolean blocking) {
        TcpChannel.closeChannels(Collections.singletonList(channel), blocking);
    }

    public static <C extends TcpChannel> void closeChannels(List<C> channels, boolean blocking) {
        if (blocking) {
            ArrayList<ActionFuture<Void>> futures = new ArrayList<ActionFuture<Void>>(channels.size());
            for (TcpChannel channel : channels) {
                if (!channel.isOpen()) continue;
                PlainActionFuture<Void> closeFuture = PlainActionFuture.newFuture();
                channel.addCloseListener(closeFuture);
                channel.close();
                futures.add(closeFuture);
            }
            TcpChannel.blockOnFutures(futures);
        } else {
            Releasables.close(channels);
        }
    }

    public static void awaitConnected(DiscoveryNode discoveryNode, List<ActionFuture<Void>> connectionFutures, TimeValue connectTimeout) throws ConnectTransportException {
        Exception connectionException = null;
        boolean allConnected = true;
        for (ActionFuture<Void> connectionFuture : connectionFutures) {
            try {
                connectionFuture.get(connectTimeout.getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                allConnected = false;
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                allConnected = false;
                connectionException = (Exception)e.getCause();
                break;
            }
        }
        if (!allConnected) {
            if (connectionException == null) {
                throw new ConnectTransportException(discoveryNode, "connect_timeout[" + connectTimeout + "]");
            }
            throw new ConnectTransportException(discoveryNode, "connect_exception", connectionException);
        }
    }

    public static void blockOnFutures(List<ActionFuture<Void>> futures) {
        for (ActionFuture<Void> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Future got interrupted", e);
            }
        }
    }
}

