/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Streamable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;

public class RestoreInfo
implements ToXContentObject,
Streamable {
    private String name;
    private List<String> indices;
    private int totalShards;
    private int successfulShards;

    RestoreInfo() {
    }

    public RestoreInfo(String name, List<String> indices, int totalShards, int successfulShards) {
        this.name = name;
        this.indices = indices;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
    }

    public String name() {
        return this.name;
    }

    public List<String> indices() {
        return this.indices;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public RestStatus status() {
        return RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("snapshot", this.name);
        builder.startArray("indices");
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.startObject("shards");
        builder.field("total", this.totalShards);
        builder.field("failed", this.failedShards());
        builder.field("successful", this.successfulShards);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        int size = in.readVInt();
        ArrayList<String> indicesListBuilder = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            indicesListBuilder.add(in.readString());
        }
        this.indices = Collections.unmodifiableList(indicesListBuilder);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.indices.size());
        for (String index : this.indices) {
            out.writeString(index);
        }
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
    }

    public static RestoreInfo readRestoreInfo(StreamInput in) throws IOException {
        RestoreInfo snapshotInfo = new RestoreInfo();
        snapshotInfo.readFrom(in);
        return snapshotInfo;
    }

    public static RestoreInfo readOptionalRestoreInfo(StreamInput in) throws IOException {
        return in.readOptionalStreamable(RestoreInfo::new);
    }

    static final class Fields {
        static final String SNAPSHOT = "snapshot";
        static final String INDICES = "indices";
        static final String SHARDS = "shards";
        static final String TOTAL = "total";
        static final String FAILED = "failed";
        static final String SUCCESSFUL = "successful";

        Fields() {
        }
    }
}

