/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;

public abstract class MultiValuesSourceAggregatorFactory<VS extends ValuesSource, AF extends MultiValuesSourceAggregatorFactory<VS, AF>>
extends AggregatorFactory<AF> {
    protected Map<String, ValuesSourceConfig<VS>> configs;

    public MultiValuesSourceAggregatorFactory(String name, Map<String, ValuesSourceConfig<VS>> configs, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metaData);
        this.configs = configs;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        HashMap<String, VS> valuesSources = new HashMap<String, VS>();
        for (Map.Entry<String, ValuesSourceConfig<VS>> config : this.configs.entrySet()) {
            VS vs = config.getValue().toValuesSource(this.context.getQueryShardContext());
            if (vs == null) continue;
            valuesSources.put(config.getKey(), vs);
        }
        if (valuesSources.isEmpty()) {
            return this.createUnmapped(parent, pipelineAggregators, metaData);
        }
        return this.doCreateInternal(valuesSources, parent, collectsFromSingleBucket, pipelineAggregators, metaData);
    }

    protected abstract Aggregator createUnmapped(Aggregator var1, List<PipelineAggregator> var2, Map<String, Object> var3) throws IOException;

    protected abstract Aggregator doCreateInternal(Map<String, VS> var1, Aggregator var2, boolean var3, List<PipelineAggregator> var4, Map<String, Object> var5) throws IOException;
}

