/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.stats.extended;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.stats.InternalStats;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalExtendedStats
extends InternalStats
implements ExtendedStats {
    private final double sumOfSqrs;
    private final double sigma;

    public InternalExtendedStats(String name, long count, double sum, double min, double max, double sumOfSqrs, double sigma, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, count, sum, min, max, formatter, pipelineAggregators, metaData);
        this.sumOfSqrs = sumOfSqrs;
        this.sigma = sigma;
    }

    public InternalExtendedStats(StreamInput in) throws IOException {
        super(in);
        this.sumOfSqrs = in.readDouble();
        this.sigma = in.readDouble();
    }

    @Override
    protected void writeOtherStatsTo(StreamOutput out) throws IOException {
        out.writeDouble(this.sumOfSqrs);
        out.writeDouble(this.sigma);
    }

    @Override
    public String getWriteableName() {
        return "extended_stats";
    }

    @Override
    public double value(String name) {
        if ("sum_of_squares".equals(name)) {
            return this.sumOfSqrs;
        }
        if ("variance".equals(name)) {
            return this.getVariance();
        }
        if ("std_deviation".equals(name)) {
            return this.getStdDeviation();
        }
        if ("std_upper".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.UPPER);
        }
        if ("std_lower".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.LOWER);
        }
        return super.value(name);
    }

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSqrs;
    }

    @Override
    public double getVariance() {
        return (this.sumOfSqrs - this.sum * this.sum / (double)this.count) / (double)this.count;
    }

    @Override
    public double getStdDeviation() {
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getStdDeviationBound(ExtendedStats.Bounds bound) {
        if (bound.equals((Object)ExtendedStats.Bounds.UPPER)) {
            return this.getAvg() + this.getStdDeviation() * this.sigma;
        }
        return this.getAvg() - this.getStdDeviation() * this.sigma;
    }

    @Override
    public String getSumOfSquaresAsString() {
        return this.valueAsString(Metrics.sum_of_squares.name());
    }

    @Override
    public String getVarianceAsString() {
        return this.valueAsString(Metrics.variance.name());
    }

    @Override
    public String getStdDeviationAsString() {
        return this.valueAsString(Metrics.std_deviation.name());
    }

    @Override
    public String getStdDeviationBoundAsString(ExtendedStats.Bounds bound) {
        return bound == ExtendedStats.Bounds.UPPER ? this.valueAsString(Metrics.std_upper.name()) : this.valueAsString(Metrics.std_lower.name());
    }

    @Override
    public InternalExtendedStats doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double sumOfSqrs = 0.0;
        double compensationOfSqrs = 0.0;
        for (InternalAggregation aggregation : aggregations) {
            InternalExtendedStats stats = (InternalExtendedStats)aggregation;
            if (stats.sigma != this.sigma) {
                throw new IllegalStateException("Cannot reduce other stats aggregations that have a different sigma");
            }
            double value = stats.getSumOfSquares();
            if (!Double.isFinite(value)) {
                sumOfSqrs += value;
                continue;
            }
            if (!Double.isFinite(sumOfSqrs)) continue;
            double correctedOfSqrs = value - compensationOfSqrs;
            double newSumOfSqrs = sumOfSqrs + correctedOfSqrs;
            compensationOfSqrs = newSumOfSqrs - sumOfSqrs - correctedOfSqrs;
            sumOfSqrs = newSumOfSqrs;
        }
        InternalAggregation stats = super.doReduce((List)aggregations, reduceContext);
        return new InternalExtendedStats(this.name, ((InternalStats)stats).getCount(), ((InternalStats)stats).getSum(), ((InternalStats)stats).getMin(), ((InternalStats)stats).getMax(), sumOfSqrs, this.sigma, this.format, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    protected XContentBuilder otherStatsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.count != 0L) {
            builder.field("sum_of_squares", this.sumOfSqrs);
            builder.field("variance", this.getVariance());
            builder.field("std_deviation", this.getStdDeviation());
            builder.startObject("std_deviation_bounds");
            builder.field("upper", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER));
            builder.field("lower", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER));
            builder.endObject();
            if (this.format != DocValueFormat.RAW) {
                builder.field("sum_of_squares_as_string", this.format.format(this.sumOfSqrs));
                builder.field("variance_as_string", this.format.format(this.getVariance()));
                builder.field("std_deviation_as_string", this.getStdDeviationAsString());
                builder.startObject("std_deviation_bounds_as_string");
                builder.field("upper", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER));
                builder.field("lower", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER));
                builder.endObject();
            }
        } else {
            builder.nullField("sum_of_squares");
            builder.nullField("variance");
            builder.nullField("std_deviation");
            builder.startObject("std_deviation_bounds");
            builder.nullField("upper");
            builder.nullField("lower");
            builder.endObject();
        }
        return builder;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(super.doHashCode(), this.sumOfSqrs, this.sigma);
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalExtendedStats other = (InternalExtendedStats)obj;
        return super.doEquals(obj) && Double.compare(this.sumOfSqrs, other.sumOfSqrs) == 0 && Double.compare(this.sigma, other.sigma) == 0;
    }

    static class Fields {
        public static final String SUM_OF_SQRS = "sum_of_squares";
        public static final String SUM_OF_SQRS_AS_STRING = "sum_of_squares_as_string";
        public static final String VARIANCE = "variance";
        public static final String VARIANCE_AS_STRING = "variance_as_string";
        public static final String STD_DEVIATION = "std_deviation";
        public static final String STD_DEVIATION_AS_STRING = "std_deviation_as_string";
        public static final String STD_DEVIATION_BOUNDS = "std_deviation_bounds";
        public static final String STD_DEVIATION_BOUNDS_AS_STRING = "std_deviation_bounds_as_string";
        public static final String UPPER = "upper";
        public static final String LOWER = "lower";

        Fields() {
        }
    }

    static enum Metrics {
        count,
        sum,
        min,
        max,
        avg,
        sum_of_squares,
        variance,
        std_deviation,
        std_upper,
        std_lower;


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name);
        }
    }
}

