/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.EnvironmentAwareCommand;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.Terminal;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.UserException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.SuppressForbidden;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.PathUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.KeyStoreWrapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;

class AddFileKeyStoreCommand
extends EnvironmentAwareCommand {
    private final OptionSpec<Void> forceOption;
    private final OptionSpec<String> arguments;

    AddFileKeyStoreCommand() {
        super("Add a file setting to the keystore");
        this.forceOption = this.parser.acceptsAll(Arrays.asList("f", "force"), "Overwrite existing setting without prompting");
        this.arguments = this.parser.nonOptions("setting [filepath]");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        KeyStoreWrapper keystore = KeyStoreWrapper.load(env.configFile());
        if (keystore == null) {
            if (!options.has(this.forceOption) && !terminal.promptYesNo("The elasticsearch keystore does not exist. Do you want to create it?", false)) {
                terminal.println("Exiting without creating keystore.");
                return;
            }
            keystore = KeyStoreWrapper.create();
            keystore.save(env.configFile(), new char[0]);
            terminal.println("Created elasticsearch keystore in " + env.configFile());
        } else {
            keystore.decrypt(new char[0]);
        }
        List argumentValues = this.arguments.values(options);
        if (argumentValues.size() == 0) {
            throw new UserException(64, "Missing setting name");
        }
        String setting = (String)argumentValues.get(0);
        if (keystore.getSettingNames().contains(setting) && !options.has(this.forceOption) && !terminal.promptYesNo("Setting " + setting + " already exists. Overwrite?", false)) {
            terminal.println("Exiting without modifying keystore.");
            return;
        }
        if (argumentValues.size() == 1) {
            throw new UserException(64, "Missing file name");
        }
        Path file = this.getPath((String)argumentValues.get(1));
        if (!Files.exists(file, new LinkOption[0])) {
            throw new UserException(74, "File [" + file.toString() + "] does not exist");
        }
        if (argumentValues.size() > 2) {
            throw new UserException(64, "Unrecognized extra arguments [" + String.join((CharSequence)", ", argumentValues.subList(2, argumentValues.size())) + "] after filepath");
        }
        keystore.setFile(setting, Files.readAllBytes(file));
        keystore.save(env.configFile(), new char[0]);
    }

    @SuppressForbidden(reason="file arg for cli")
    private Path getPath(String file) {
        return PathUtils.get(file, new String[0]);
    }
}

