/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.ByteBlockPool;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRefIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.FutureObjects;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.IntroSorter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.SortableBytesRefArray;

public final class BytesRefArray
implements SortableBytesRefArray {
    private final ByteBlockPool pool;
    private int[] offsets = new int[1];
    private int lastElement = 0;
    private int currentOffset = 0;
    private final Counter bytesUsed;

    public BytesRefArray(Counter bytesUsed) {
        this.pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(bytesUsed));
        this.pool.nextBuffer();
        bytesUsed.addAndGet(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * 4);
        this.bytesUsed = bytesUsed;
    }

    @Override
    public void clear() {
        this.lastElement = 0;
        this.currentOffset = 0;
        Arrays.fill(this.offsets, 0);
        this.pool.reset(false, true);
    }

    @Override
    public int append(BytesRef bytes) {
        if (this.lastElement >= this.offsets.length) {
            int oldLen = this.offsets.length;
            this.offsets = ArrayUtil.grow(this.offsets, this.offsets.length + 1);
            this.bytesUsed.addAndGet((this.offsets.length - oldLen) * 4);
        }
        this.pool.append(bytes);
        this.offsets[this.lastElement++] = this.currentOffset;
        this.currentOffset += bytes.length;
        return this.lastElement - 1;
    }

    @Override
    public int size() {
        return this.lastElement;
    }

    public BytesRef get(BytesRefBuilder spare, int index) {
        FutureObjects.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        spare.grow(length);
        spare.setLength(length);
        this.pool.readBytes(offset, spare.bytes(), 0, spare.length());
        return spare.get();
    }

    private void setBytesRef(BytesRefBuilder spare, BytesRef result, int index) {
        FutureObjects.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        this.pool.setBytesRef(spare, result, offset, length);
    }

    private int[] sort(final Comparator<BytesRef> comp) {
        final int[] orderedEntries = new int[this.size()];
        for (int i = 0; i < orderedEntries.length; ++i) {
            orderedEntries[i] = i;
        }
        new IntroSorter(){
            private final BytesRef pivot = new BytesRef();
            private final BytesRef scratchBytes1 = new BytesRef();
            private final BytesRef scratchBytes2 = new BytesRef();
            private final BytesRefBuilder pivotBuilder = new BytesRefBuilder();
            private final BytesRefBuilder scratch1 = new BytesRefBuilder();
            private final BytesRefBuilder scratch2 = new BytesRefBuilder();

            @Override
            protected void swap(int i, int j) {
                int o = orderedEntries[i];
                orderedEntries[i] = orderedEntries[j];
                orderedEntries[j] = o;
            }

            @Override
            protected int compare(int i, int j) {
                int idx1 = orderedEntries[i];
                int idx2 = orderedEntries[j];
                BytesRefArray.this.setBytesRef(this.scratch1, this.scratchBytes1, idx1);
                BytesRefArray.this.setBytesRef(this.scratch2, this.scratchBytes2, idx2);
                return comp.compare(this.scratchBytes1, this.scratchBytes2);
            }

            @Override
            protected void setPivot(int i) {
                int index = orderedEntries[i];
                BytesRefArray.this.setBytesRef(this.pivotBuilder, this.pivot, index);
            }

            @Override
            protected int comparePivot(int j) {
                int index = orderedEntries[j];
                BytesRefArray.this.setBytesRef(this.scratch2, this.scratchBytes2, index);
                return comp.compare(this.pivot, this.scratchBytes2);
            }
        }.sort(0, this.size());
        return orderedEntries;
    }

    public BytesRefIterator iterator() {
        return this.iterator(null);
    }

    @Override
    public BytesRefIterator iterator(Comparator<BytesRef> comp) {
        final BytesRefBuilder spare = new BytesRefBuilder();
        final BytesRef result = new BytesRef();
        final int size = this.size();
        final int[] indices = comp == null ? null : this.sort(comp);
        return new BytesRefIterator(){
            int pos = 0;

            @Override
            public BytesRef next() {
                if (this.pos < size) {
                    int n;
                    if (indices == null) {
                        int n2 = this.pos;
                        n = n2;
                        this.pos = n2 + 1;
                    } else {
                        n = indices[this.pos++];
                    }
                    BytesRefArray.this.setBytesRef(spare, result, n);
                    return result;
                }
                return null;
            }
        };
    }
}

