/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.docvalues;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.FunctionValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.mutable.MutableValue;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.mutable.MutableValueFloat;

public abstract class FloatDocValues
extends FunctionValues {
    protected final ValueSource vs;

    public FloatDocValues(ValueSource vs) {
        this.vs = vs;
    }

    @Override
    public byte byteVal(int doc) throws IOException {
        return (byte)this.floatVal(doc);
    }

    @Override
    public short shortVal(int doc) throws IOException {
        return (short)this.floatVal(doc);
    }

    @Override
    public abstract float floatVal(int var1) throws IOException;

    @Override
    public int intVal(int doc) throws IOException {
        return (int)this.floatVal(doc);
    }

    @Override
    public long longVal(int doc) throws IOException {
        return (long)this.floatVal(doc);
    }

    @Override
    public boolean boolVal(int doc) throws IOException {
        return this.floatVal(doc) != 0.0f;
    }

    @Override
    public double doubleVal(int doc) throws IOException {
        return this.floatVal(doc);
    }

    @Override
    public String strVal(int doc) throws IOException {
        return Float.toString(this.floatVal(doc));
    }

    @Override
    public Object objectVal(int doc) throws IOException {
        return this.exists(doc) ? Float.valueOf(this.floatVal(doc)) : null;
    }

    @Override
    public String toString(int doc) throws IOException {
        return this.vs.description() + '=' + this.strVal(doc);
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueFloat mval = new MutableValueFloat();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc) throws IOException {
                this.mval.value = FloatDocValues.this.floatVal(doc);
                this.mval.exists = FloatDocValues.this.exists(doc);
            }
        };
    }
}

