/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.codecs.DocValuesProducer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.codecs.FieldsProducer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.codecs.NormsProducer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.codecs.TermVectorsReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.CodecReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Fields;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafMetaData;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.PointValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.StoredFieldVisitor;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.FutureObjects;

class MergeReaderWrapper
extends LeafReader {
    final CodecReader in;
    final FieldsProducer fields;
    final NormsProducer norms;
    final DocValuesProducer docValues;
    final StoredFieldsReader store;
    final TermVectorsReader vectors;

    MergeReaderWrapper(CodecReader in) throws IOException {
        this.in = in;
        FieldsProducer fields = in.getPostingsReader();
        if (fields != null) {
            fields = fields.getMergeInstance();
        }
        this.fields = fields;
        NormsProducer norms = in.getNormsReader();
        if (norms != null) {
            norms = norms.getMergeInstance();
        }
        this.norms = norms;
        DocValuesProducer docValues = in.getDocValuesReader();
        if (docValues != null) {
            docValues = docValues.getMergeInstance();
        }
        this.docValues = docValues;
        StoredFieldsReader store = in.getFieldsReader();
        if (store != null) {
            store = store.getMergeInstance();
        }
        this.store = store;
        TermVectorsReader vectors = in.getTermVectorsReader();
        if (vectors != null) {
            vectors = vectors.getMergeInstance();
        }
        this.vectors = vectors;
    }

    @Override
    public Terms terms(String field) throws IOException {
        this.ensureOpen();
        return this.fields.terms(field);
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.NUMERIC) {
            return null;
        }
        return this.docValues.getNumeric(fi);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.BINARY) {
            return null;
        }
        return this.docValues.getBinary(fi);
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED) {
            return null;
        }
        return this.docValues.getSorted(fi);
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED_NUMERIC) {
            return null;
        }
        return this.docValues.getSortedNumeric(fi);
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED_SET) {
            return null;
        }
        return this.docValues.getSortedSet(fi);
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.norms.getNorms(fi);
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.in.getFieldInfos();
    }

    @Override
    public Bits getLiveDocs() {
        return this.in.getLiveDocs();
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.in.checkIntegrity();
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        this.ensureOpen();
        this.checkBounds(docID);
        if (this.vectors == null) {
            return null;
        }
        return this.vectors.get(docID);
    }

    @Override
    public PointValues getPointValues(String fieldName) throws IOException {
        return this.in.getPointValues(fieldName);
    }

    @Override
    public int numDocs() {
        return this.in.numDocs();
    }

    @Override
    public int maxDoc() {
        return this.in.maxDoc();
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.checkBounds(docID);
        this.store.visitDocument(docID, visitor);
    }

    @Override
    protected void doClose() throws IOException {
        this.in.close();
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private void checkBounds(int docID) {
        FutureObjects.checkIndex(docID, this.maxDoc());
    }

    public String toString() {
        return "MergeReaderWrapper(" + this.in + ")";
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.in.getMetaData();
    }
}

