/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.es;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.es.SpanishLightStemmer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class SpanishLightStemFilter
extends TokenFilter {
    private final SpanishLightStemmer stemmer = new SpanishLightStemmer();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public SpanishLightStemFilter(TokenStream input) {
        super(input);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                int newlen = this.stemmer.stem(this.termAtt.buffer(), this.termAtt.length());
                this.termAtt.setLength(newlen);
            }
            return true;
        }
        return false;
    }
}

