/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.descriptors.ConnectorDescriptorValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;

@Internal
public class ElasticsearchValidator
extends ConnectorDescriptorValidator {
    public static final String CONNECTOR_TYPE_VALUE_ELASTICSEARCH = "elasticsearch";
    public static final String CONNECTOR_VERSION_VALUE_6 = "6";
    public static final String CONNECTOR_HOSTS = "connector.hosts";
    public static final String CONNECTOR_HOSTS_HOSTNAME = "hostname";
    public static final String CONNECTOR_HOSTS_PORT = "port";
    public static final String CONNECTOR_HOSTS_PROTOCOL = "protocol";
    public static final String CONNECTOR_INDEX = "connector.index";
    public static final String CONNECTOR_DOCUMENT_TYPE = "connector.document-type";
    public static final String CONNECTOR_KEY_DELIMITER = "connector.key-delimiter";
    public static final String CONNECTOR_KEY_NULL_LITERAL = "connector.key-null-literal";
    public static final String CONNECTOR_FAILURE_HANDLER = "connector.failure-handler";
    public static final String CONNECTOR_FAILURE_HANDLER_VALUE_FAIL = "fail";
    public static final String CONNECTOR_FAILURE_HANDLER_VALUE_IGNORE = "ignore";
    public static final String CONNECTOR_FAILURE_HANDLER_VALUE_RETRY = "retry-rejected";
    public static final String CONNECTOR_FAILURE_HANDLER_VALUE_CUSTOM = "custom";
    public static final String CONNECTOR_FAILURE_HANDLER_CLASS = "connector.failure-handler-class";
    public static final String CONNECTOR_FLUSH_ON_CHECKPOINT = "connector.flush-on-checkpoint";
    public static final String CONNECTOR_BULK_FLUSH_MAX_ACTIONS = "connector.bulk-flush.max-actions";
    public static final String CONNECTOR_BULK_FLUSH_MAX_SIZE = "connector.bulk-flush.max-size";
    public static final String CONNECTOR_BULK_FLUSH_INTERVAL = "connector.bulk-flush.interval";
    public static final String CONNECTOR_BULK_FLUSH_BACKOFF_TYPE = "connector.bulk-flush.backoff.type";
    public static final String CONNECTOR_BULK_FLUSH_BACKOFF_TYPE_VALUE_DISABLED = "disabled";
    public static final String CONNECTOR_BULK_FLUSH_BACKOFF_TYPE_VALUE_CONSTANT = "constant";
    public static final String CONNECTOR_BULK_FLUSH_BACKOFF_TYPE_VALUE_EXPONENTIAL = "exponential";
    public static final String CONNECTOR_BULK_FLUSH_BACKOFF_MAX_RETRIES = "connector.bulk-flush.backoff.max-retries";
    public static final String CONNECTOR_BULK_FLUSH_BACKOFF_DELAY = "connector.bulk-flush.backoff.delay";
    public static final String CONNECTOR_CONNECTION_MAX_RETRY_TIMEOUT = "connector.connection-max-retry-timeout";
    public static final String CONNECTOR_CONNECTION_PATH_PREFIX = "connector.connection-path-prefix";

    public void validate(DescriptorProperties properties) {
        super.validate(properties);
        properties.validateValue("connector.type", CONNECTOR_TYPE_VALUE_ELASTICSEARCH, false);
        this.validateVersion(properties);
        this.validateHosts(properties);
        this.validateGeneralProperties(properties);
        this.validateFailureHandler(properties);
        this.validateBulkFlush(properties);
        this.validateConnectionProperties(properties);
    }

    private void validateVersion(DescriptorProperties properties) {
        properties.validateEnumValues("connector.version", false, Collections.singletonList(CONNECTOR_VERSION_VALUE_6));
    }

    private void validateHosts(DescriptorProperties properties) {
        HashMap<String, Consumer<String>> hostsValidators = new HashMap<String, Consumer<String>>();
        hostsValidators.put(CONNECTOR_HOSTS_HOSTNAME, key -> properties.validateString(key, false, 1));
        hostsValidators.put(CONNECTOR_HOSTS_PORT, key -> properties.validateInt(key, false, 0, 65535));
        hostsValidators.put(CONNECTOR_HOSTS_PROTOCOL, key -> properties.validateString(key, false, 1));
        properties.validateFixedIndexedProperties(CONNECTOR_HOSTS, false, hostsValidators);
    }

    private void validateGeneralProperties(DescriptorProperties properties) {
        properties.validateString(CONNECTOR_INDEX, false, 1);
        properties.validateString(CONNECTOR_DOCUMENT_TYPE, false, 1);
        properties.validateString(CONNECTOR_KEY_DELIMITER, true);
        properties.validateString(CONNECTOR_KEY_NULL_LITERAL, true);
    }

    private void validateFailureHandler(DescriptorProperties properties) {
        HashMap<String, Consumer<String>> failureHandlerValidators = new HashMap<String, Consumer<String>>();
        failureHandlerValidators.put(CONNECTOR_FAILURE_HANDLER_VALUE_FAIL, DescriptorProperties.noValidation());
        failureHandlerValidators.put(CONNECTOR_FAILURE_HANDLER_VALUE_IGNORE, DescriptorProperties.noValidation());
        failureHandlerValidators.put(CONNECTOR_FAILURE_HANDLER_VALUE_RETRY, DescriptorProperties.noValidation());
        failureHandlerValidators.put(CONNECTOR_FAILURE_HANDLER_VALUE_CUSTOM, key -> properties.validateString(CONNECTOR_FAILURE_HANDLER_CLASS, false, 1));
        properties.validateEnum(CONNECTOR_FAILURE_HANDLER, true, failureHandlerValidators);
    }

    private void validateBulkFlush(DescriptorProperties properties) {
        properties.validateBoolean(CONNECTOR_FLUSH_ON_CHECKPOINT, true);
        properties.validateInt(CONNECTOR_BULK_FLUSH_MAX_ACTIONS, true, 1);
        properties.validateMemorySize(CONNECTOR_BULK_FLUSH_MAX_SIZE, true, 0x100000);
        properties.validateLong(CONNECTOR_BULK_FLUSH_INTERVAL, true, 0L);
        properties.validateEnumValues(CONNECTOR_BULK_FLUSH_BACKOFF_TYPE, true, Arrays.asList(CONNECTOR_BULK_FLUSH_BACKOFF_TYPE_VALUE_DISABLED, CONNECTOR_BULK_FLUSH_BACKOFF_TYPE_VALUE_CONSTANT, CONNECTOR_BULK_FLUSH_BACKOFF_TYPE_VALUE_EXPONENTIAL));
        properties.validateInt(CONNECTOR_BULK_FLUSH_BACKOFF_MAX_RETRIES, true, 1);
        properties.validateLong(CONNECTOR_BULK_FLUSH_BACKOFF_DELAY, true, 0L);
    }

    private void validateConnectionProperties(DescriptorProperties properties) {
        properties.validateInt(CONNECTOR_CONNECTION_MAX_RETRY_TIMEOUT, true, 1);
        properties.validateString(CONNECTOR_CONNECTION_PATH_PREFIX, true);
    }
}

