/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.FuzzyQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.BytesRefs;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.Fuzziness;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.support.QueryParsers;

public class FuzzyQueryBuilder
extends AbstractQueryBuilder<FuzzyQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "fuzzy";
    public static final Fuzziness DEFAULT_FUZZINESS = Fuzziness.AUTO;
    public static final int DEFAULT_PREFIX_LENGTH = 0;
    public static final int DEFAULT_MAX_EXPANSIONS = 50;
    public static final boolean DEFAULT_TRANSPOSITIONS = false;
    private static final ParseField TERM_FIELD = new ParseField("term", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ParseField PREFIX_LENGTH_FIELD = new ParseField("prefix_length", new String[0]);
    private static final ParseField MAX_EXPANSIONS_FIELD = new ParseField("max_expansions", new String[0]);
    private static final ParseField TRANSPOSITIONS_FIELD = new ParseField("transpositions", new String[0]);
    private static final ParseField REWRITE_FIELD = new ParseField("rewrite", new String[0]);
    private final String fieldName;
    private final Object value;
    private Fuzziness fuzziness = DEFAULT_FUZZINESS;
    private int prefixLength = 0;
    private int maxExpansions = 50;
    private boolean transpositions = false;
    private String rewrite;

    public FuzzyQueryBuilder(String fieldName, String value) {
        this(fieldName, (Object)value);
    }

    public FuzzyQueryBuilder(String fieldName, int value) {
        this(fieldName, (Object)value);
    }

    public FuzzyQueryBuilder(String fieldName, long value) {
        this(fieldName, (Object)value);
    }

    public FuzzyQueryBuilder(String fieldName, float value) {
        this(fieldName, Float.valueOf(value));
    }

    public FuzzyQueryBuilder(String fieldName, double value) {
        this(fieldName, (Object)value);
    }

    public FuzzyQueryBuilder(String fieldName, boolean value) {
        this(fieldName, (Object)value);
    }

    public FuzzyQueryBuilder(String fieldName, Object value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name cannot be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("query value cannot be null");
        }
        this.fieldName = fieldName;
        this.value = FuzzyQueryBuilder.maybeConvertToBytesRef(value);
    }

    public FuzzyQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readGenericValue();
        this.fuzziness = new Fuzziness(in);
        this.prefixLength = in.readVInt();
        this.maxExpansions = in.readVInt();
        this.transpositions = in.readBoolean();
        this.rewrite = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.value);
        this.fuzziness.writeTo(out);
        out.writeVInt(this.prefixLength);
        out.writeVInt(this.maxExpansions);
        out.writeBoolean(this.transpositions);
        out.writeOptionalString(this.rewrite);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object value() {
        return FuzzyQueryBuilder.maybeConvertToString(this.value);
    }

    public FuzzyQueryBuilder fuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness == null ? DEFAULT_FUZZINESS : fuzziness;
        return this;
    }

    public Fuzziness fuzziness() {
        return this.fuzziness;
    }

    public FuzzyQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public FuzzyQueryBuilder maxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
        return this;
    }

    public int maxExpansions() {
        return this.maxExpansions;
    }

    public FuzzyQueryBuilder transpositions(boolean transpositions) {
        this.transpositions = transpositions;
        return this;
    }

    public boolean transpositions() {
        return this.transpositions;
    }

    public FuzzyQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public String rewrite() {
        return this.rewrite;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(VALUE_FIELD.getPreferredName(), FuzzyQueryBuilder.maybeConvertToString(this.value));
        this.fuzziness.toXContent(builder, params);
        builder.field(PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength);
        builder.field(MAX_EXPANSIONS_FIELD.getPreferredName(), this.maxExpansions);
        builder.field(TRANSPOSITIONS_FIELD.getPreferredName(), this.transpositions);
        if (this.rewrite != null) {
            builder.field(REWRITE_FIELD.getPreferredName(), this.rewrite);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static FuzzyQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        Object value = null;
        Fuzziness fuzziness = DEFAULT_FUZZINESS;
        int prefixLength = 0;
        int maxExpansions = 50;
        boolean transpositions = false;
        String rewrite = null;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                FuzzyQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (TERM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            value = FuzzyQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                            continue;
                        }
                        if (VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            value = FuzzyQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                            continue;
                        }
                        if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            boost = parser.floatValue();
                            continue;
                        }
                        if (Fuzziness.FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            fuzziness = Fuzziness.parse(parser);
                            continue;
                        }
                        if (PREFIX_LENGTH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            prefixLength = parser.intValue();
                            continue;
                        }
                        if (MAX_EXPANSIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            maxExpansions = parser.intValue();
                            continue;
                        }
                        if (TRANSPOSITIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            transpositions = parser.booleanValue();
                            continue;
                        }
                        if (REWRITE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            rewrite = parser.textOrNull();
                            continue;
                        }
                        if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            queryName = parser.text();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[fuzzy] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[fuzzy] unexpected token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            FuzzyQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = FuzzyQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
        }
        return (FuzzyQueryBuilder)((FuzzyQueryBuilder)new FuzzyQueryBuilder(fieldName, value).fuzziness(fuzziness).prefixLength(prefixLength).maxExpansions(maxExpansions).transpositions(transpositions).rewrite(rewrite).boost(boost)).queryName(queryName);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType fieldType;
        Query query = null;
        String rewrite = this.rewrite;
        if (rewrite == null && context.isFilter()) {
            rewrite = QueryParsers.CONSTANT_SCORE.getPreferredName();
        }
        if ((fieldType = context.fieldMapper(this.fieldName)) != null) {
            query = fieldType.fuzzyQuery(this.value, this.fuzziness, this.prefixLength, this.maxExpansions, this.transpositions);
        }
        if (query == null) {
            int maxEdits = this.fuzziness.asDistance(BytesRefs.toString(this.value));
            query = new FuzzyQuery(new Term(this.fieldName, BytesRefs.toBytesRef(this.value)), maxEdits, this.prefixLength, this.maxExpansions, this.transpositions);
        }
        if (query instanceof MultiTermQuery) {
            MultiTermQuery.RewriteMethod rewriteMethod = QueryParsers.parseRewriteMethod(rewrite, null, LoggingDeprecationHandler.INSTANCE);
            QueryParsers.setRewriteMethod((MultiTermQuery)query, rewriteMethod);
        }
        return query;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.fuzziness, this.prefixLength, this.maxExpansions, this.transpositions, this.rewrite);
    }

    @Override
    protected boolean doEquals(FuzzyQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.maxExpansions, other.maxExpansions) && Objects.equals(this.transpositions, other.transpositions) && Objects.equals(this.rewrite, other.rewrite);
    }
}

