/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.compress.CompressedXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.IndexAnalyzers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.DocumentMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.RootObjectMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.similarity.SimilarityService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.mapper.MapperRegistry;

public class DocumentMapperParser {
    final MapperService mapperService;
    final IndexAnalyzers indexAnalyzers;
    private final NamedXContentRegistry xContentRegistry;
    private final SimilarityService similarityService;
    private final Supplier<QueryShardContext> queryShardContextSupplier;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Version indexVersionCreated;
    private final Map<String, Mapper.TypeParser> typeParsers;
    private final Map<String, MetadataFieldMapper.TypeParser> rootTypeParsers;

    public DocumentMapperParser(IndexSettings indexSettings, MapperService mapperService, IndexAnalyzers indexAnalyzers, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<QueryShardContext> queryShardContextSupplier) {
        this.mapperService = mapperService;
        this.indexAnalyzers = indexAnalyzers;
        this.xContentRegistry = xContentRegistry;
        this.similarityService = similarityService;
        this.queryShardContextSupplier = queryShardContextSupplier;
        this.typeParsers = mapperRegistry.getMapperParsers();
        this.rootTypeParsers = mapperRegistry.getMetadataMapperParsers();
        this.indexVersionCreated = indexSettings.getIndexVersionCreated();
    }

    public Mapper.TypeParser.ParserContext parserContext(String type) {
        return new Mapper.TypeParser.ParserContext(type, this.indexAnalyzers, this.similarityService::getSimilarity, this.mapperService, this.typeParsers::get, this.indexVersionCreated, this.queryShardContextSupplier);
    }

    public DocumentMapper parse(@Nullable String type, CompressedXContent source) throws MapperParsingException {
        return this.parse(type, source, null);
    }

    public DocumentMapper parse(@Nullable String type, CompressedXContent source, String defaultSource) throws MapperParsingException {
        Map<String, Object> mapping = null;
        if (source != null) {
            Map<String, Object> root = XContentHelper.convertToMap(source.compressedReference(), true, XContentType.JSON).v2();
            Tuple<String, Map<String, Object>> t = this.extractMapping(type, root);
            type = t.v1();
            mapping = t.v2();
        }
        if (mapping == null) {
            mapping = new HashMap<String, Object>();
        }
        return this.parse(type, mapping, defaultSource);
    }

    private DocumentMapper parse(String type, Map<String, Object> mapping, String defaultSource) throws MapperParsingException {
        Tuple<String, Map<String, Object>> t;
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        if (defaultSource != null && (t = this.extractMapping("_default_", defaultSource)).v2() != null) {
            XContentHelper.mergeDefaults(mapping, t.v2());
        }
        Mapper.TypeParser.ParserContext parserContext = this.parserContext(type);
        DocumentMapper.Builder docBuilder = new DocumentMapper.Builder((RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, mapping, parserContext), this.mapperService);
        Iterator<Map.Entry<String, Object>> iterator = mapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            Object fieldNode = entry.getValue();
            MetadataFieldMapper.TypeParser typeParser = this.rootTypeParsers.get(fieldName);
            if (typeParser == null) continue;
            iterator.remove();
            if (!(fieldNode instanceof Map)) {
                throw new IllegalArgumentException("[_parent] must be an object containing [type]");
            }
            Map fieldNodeMap = (Map)fieldNode;
            docBuilder.put((MetadataFieldMapper.Builder<?, ?>)typeParser.parse(fieldName, fieldNodeMap, parserContext));
            fieldNodeMap.remove("type");
            DocumentMapperParser.checkNoRemainingFields(fieldName, fieldNodeMap, parserContext.indexVersionCreated());
        }
        Map meta = (Map)mapping.remove("_meta");
        if (meta != null) {
            docBuilder.meta(Collections.unmodifiableMap(new HashMap(meta)));
        }
        DocumentMapperParser.checkNoRemainingFields(mapping, parserContext.indexVersionCreated(), "Root mapping definition has unsupported parameters: ");
        return docBuilder.build(this.mapperService);
    }

    public static void checkNoRemainingFields(String fieldName, Map<?, ?> fieldNodeMap, Version indexVersionCreated) {
        DocumentMapperParser.checkNoRemainingFields(fieldNodeMap, indexVersionCreated, "Mapping definition for [" + fieldName + "] has unsupported parameters: ");
    }

    public static void checkNoRemainingFields(Map<?, ?> fieldNodeMap, Version indexVersionCreated, String message) {
        if (!fieldNodeMap.isEmpty()) {
            throw new MapperParsingException(message + DocumentMapperParser.getRemainingFields(fieldNodeMap));
        }
    }

    private static String getRemainingFields(Map<?, ?> map) {
        StringBuilder remainingFields = new StringBuilder();
        for (Object key : map.keySet()) {
            remainingFields.append(" [").append(key).append(" : ").append(map.get(key)).append("]");
        }
        return remainingFields.toString();
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, String source) throws MapperParsingException {
        Map<String, Object> root;
        try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, source);){
            root = parser.mapOrdered();
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse mapping definition", e);
        }
        return this.extractMapping(type, root);
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, Map<String, Object> root) throws MapperParsingException {
        if (root.size() == 0) {
            throw new MapperParsingException("malformed mapping no root object found");
        }
        String rootName = root.keySet().iterator().next();
        Tuple<String, Map<String, Object>> mapping = type == null || type.equals(rootName) ? new Tuple<String, Map<String, Object>>(rootName, (Map)root.get(rootName)) : new Tuple<String, Map<String, Object>>(type, root);
        return mapping;
    }

    NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }
}

