/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.AnalysisRegistry;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.TokenFilterFactory;

public class SynonymGraphTokenFilterFactory
extends SynonymTokenFilterFactory {
    public SynonymGraphTokenFilterFactory(IndexSettings indexSettings, Environment env, AnalysisRegistry analysisRegistry, String name, Settings settings) throws IOException {
        super(indexSettings, env, analysisRegistry, name, settings);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        throw new IllegalStateException("Call createPerAnalyzerSynonymGraphFactory to specialize this factory for an analysis chain first");
    }

    Factory createPerAnalyzerSynonymGraphFactory(Analyzer analyzerForParseSynonym, Environment env) {
        return new Factory("synonymgraph", analyzerForParseSynonym, this.getRulesFromSettings(env));
    }

    public class Factory
    implements TokenFilterFactory {
        private final String name;
        private final SynonymMap synonymMap;

        public Factory(String name, Analyzer analyzerForParseSynonym, Reader rulesReader) {
            this.name = name;
            try {
                SynonymMap.Parser parser;
                if ("wordnet".equalsIgnoreCase(SynonymGraphTokenFilterFactory.this.format)) {
                    parser = new WordnetSynonymParser(true, SynonymGraphTokenFilterFactory.this.expand, analyzerForParseSynonym);
                    ((WordnetSynonymParser)parser).parse(rulesReader);
                } else {
                    parser = new SolrSynonymParser(true, SynonymGraphTokenFilterFactory.this.expand, analyzerForParseSynonym);
                    ((SolrSynonymParser)parser).parse(rulesReader);
                }
                this.synonymMap = parser.build();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to build synonyms", e);
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            return this.synonymMap.fst == null ? tokenStream : new SynonymGraphFilter(tokenStream, this.synonymMap, SynonymGraphTokenFilterFactory.this.ignoreCase);
        }
    }
}

