/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.decider;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.RestoreInProgress;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.RecoverySource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.RoutingNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.Snapshot;

public class RestoreInProgressAllocationDecider
extends AllocationDecider {
    public static final String NAME = "restore_in_progress";

    public RestoreInProgressAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        RecoverySource recoverySource = shardRouting.recoverySource();
        if (recoverySource == null || recoverySource.getType() != RecoverySource.Type.SNAPSHOT) {
            return allocation.decision(Decision.YES, NAME, "ignored as shard is not being recovered from a snapshot", new Object[0]);
        }
        Snapshot snapshot = ((RecoverySource.SnapshotRecoverySource)recoverySource).snapshot();
        RestoreInProgress restoresInProgress = (RestoreInProgress)allocation.custom("restore");
        if (restoresInProgress != null) {
            for (RestoreInProgress.Entry restoreInProgress : restoresInProgress.entries()) {
                if (!restoreInProgress.snapshot().equals(snapshot)) continue;
                RestoreInProgress.ShardRestoreStatus shardRestoreStatus = restoreInProgress.shards().get(shardRouting.shardId());
                if (shardRestoreStatus == null || shardRestoreStatus.state().completed()) break;
                assert (shardRestoreStatus.state() != RestoreInProgress.State.SUCCESS) : "expected shard [" + shardRouting + "] to be in initializing state but got [" + (Object)((Object)shardRestoreStatus.state()) + "]";
                return allocation.decision(Decision.YES, NAME, "shard is currently being restored", new Object[0]);
            }
        }
        return allocation.decision(Decision.NO, NAME, "shard has failed to be restored from the snapshot [%s] because of [%s] - manually close or delete the index [%s] in order to retry to restore the snapshot again or use the reroute API to force the allocation of an empty primary shard", snapshot, shardRouting.unassignedInfo().getDetails(), shardRouting.getIndexName());
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + shardRouting;
        return this.canAllocate(shardRouting, node, allocation);
    }
}

