/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Priority;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;

public class RoutingService
extends AbstractLifecycleComponent {
    private static final String CLUSTER_UPDATE_TASK_SOURCE = "cluster_reroute";
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private AtomicBoolean rerouting = new AtomicBoolean();

    @Inject
    public RoutingService(Settings settings, ClusterService clusterService, AllocationService allocationService) {
        super(settings);
        this.clusterService = clusterService;
        this.allocationService = allocationService;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
    }

    public final void reroute(String reason) {
        this.performReroute(reason);
    }

    protected void performReroute(final String reason) {
        try {
            if (this.lifecycle.stopped()) {
                return;
            }
            if (!this.rerouting.compareAndSet(false, true)) {
                this.logger.trace("already has pending reroute, ignoring {}", (Object)reason);
                return;
            }
            this.logger.trace("rerouting {}", (Object)reason);
            this.clusterService.submitStateUpdateTask("cluster_reroute(" + reason + ")", new ClusterStateUpdateTask(Priority.HIGH){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RoutingService.this.rerouting.set(false);
                    return RoutingService.this.allocationService.reroute(currentState, reason);
                }

                @Override
                public void onNoLongerMaster(String source) {
                    RoutingService.this.rerouting.set(false);
                }

                @Override
                public void onFailure(String source, Exception e) {
                    RoutingService.this.rerouting.set(false);
                    ClusterState state = RoutingService.this.clusterService.state();
                    if (RoutingService.this.logger.isTraceEnabled()) {
                        RoutingService.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}], current state:\n{}", (Object)source, (Object)state), (Throwable)e);
                    } else {
                        RoutingService.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}], current state version [{}]", (Object)source, (Object)state.version()), (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.rerouting.set(false);
            ClusterState state = this.clusterService.state();
            this.logger.warn(() -> new ParameterizedMessage("failed to reroute routing table, current state:\n{}", (Object)state), (Throwable)e);
        }
    }
}

