/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.reroute;

import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Priority;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class TransportClusterRerouteAction
extends TransportMasterNodeAction<ClusterRerouteRequest, ClusterRerouteResponse> {
    private final AllocationService allocationService;

    @Inject
    public TransportClusterRerouteAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/reroute", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterRerouteRequest::new);
        this.allocationService = allocationService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterRerouteRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterRerouteResponse newResponse() {
        return new ClusterRerouteResponse();
    }

    @Override
    protected void masterOperation(ClusterRerouteRequest request, ClusterState state, ActionListener<ClusterRerouteResponse> listener) {
        ActionListener<ClusterRerouteResponse> logWrapper = ActionListener.wrap(response -> {
            if (!request.dryRun()) {
                response.getExplanations().getYesDecisionMessages().forEach(this.logger::info);
            }
            listener.onResponse((ClusterRerouteResponse)response);
        }, listener::onFailure);
        this.clusterService.submitStateUpdateTask("cluster_reroute (api)", new ClusterRerouteResponseAckedClusterStateUpdateTask(this.logger, this.allocationService, request, logWrapper));
    }

    static class ClusterRerouteResponseAckedClusterStateUpdateTask
    extends AckedClusterStateUpdateTask<ClusterRerouteResponse> {
        private final ClusterRerouteRequest request;
        private final ActionListener<ClusterRerouteResponse> listener;
        private final Logger logger;
        private final AllocationService allocationService;
        private volatile ClusterState clusterStateToSend;
        private volatile RoutingExplanations explanations;

        ClusterRerouteResponseAckedClusterStateUpdateTask(Logger logger, AllocationService allocationService, ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener) {
            super(Priority.IMMEDIATE, request, listener);
            this.request = request;
            this.listener = listener;
            this.logger = logger;
            this.allocationService = allocationService;
        }

        @Override
        protected ClusterRerouteResponse newResponse(boolean acknowledged) {
            return new ClusterRerouteResponse(acknowledged, this.clusterStateToSend, this.explanations);
        }

        @Override
        public void onAckTimeout() {
            this.listener.onResponse(new ClusterRerouteResponse(false, this.clusterStateToSend, new RoutingExplanations()));
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
            super.onFailure(source, e);
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            AllocationService.CommandsResult commandsResult = this.allocationService.reroute(currentState, this.request.getCommands(), this.request.explain(), this.request.isRetryFailed());
            this.clusterStateToSend = commandsResult.getClusterState();
            this.explanations = commandsResult.explanations();
            if (this.request.dryRun()) {
                return currentState;
            }
            return commandsResult.getClusterState();
        }
    }
}

