/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree;

import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.LegacyCell;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.LegacyPrefixTree;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class QuadPrefixTree
extends LegacyPrefixTree {
    public static final int MAX_LEVELS_POSSIBLE = 50;
    public static final int DEFAULT_MAX_LEVELS = 12;
    protected final double xmin;
    protected final double xmax;
    protected final double ymin;
    protected final double ymax;
    protected final double xmid;
    protected final double ymid;
    protected final double gridW;
    public final double gridH;
    final double[] levelW;
    final double[] levelH;
    final int[] levelS;
    final int[] levelN;

    public QuadPrefixTree(SpatialContext ctx, Rectangle bounds, int maxLevels) {
        super(ctx, maxLevels);
        this.xmin = bounds.getMinX();
        this.xmax = bounds.getMaxX();
        this.ymin = bounds.getMinY();
        this.ymax = bounds.getMaxY();
        this.levelW = new double[maxLevels];
        this.levelH = new double[maxLevels];
        this.levelS = new int[maxLevels];
        this.levelN = new int[maxLevels];
        this.gridW = this.xmax - this.xmin;
        this.gridH = this.ymax - this.ymin;
        this.xmid = this.xmin + this.gridW / 2.0;
        this.ymid = this.ymin + this.gridH / 2.0;
        this.levelW[0] = this.gridW / 2.0;
        this.levelH[0] = this.gridH / 2.0;
        this.levelS[0] = 2;
        this.levelN[0] = 4;
        for (int i = 1; i < this.levelW.length; ++i) {
            this.levelW[i] = this.levelW[i - 1] / 2.0;
            this.levelH[i] = this.levelH[i - 1] / 2.0;
            this.levelS[i] = this.levelS[i - 1] * 2;
            this.levelN[i] = this.levelN[i - 1] * 4;
        }
    }

    public QuadPrefixTree(SpatialContext ctx) {
        this(ctx, 12);
    }

    public QuadPrefixTree(SpatialContext ctx, int maxLevels) {
        this(ctx, ctx.getWorldBounds(), maxLevels);
    }

    @Override
    public Cell getWorldCell() {
        return new QuadCell(BytesRef.EMPTY_BYTES, 0, 0);
    }

    public void printInfo(PrintStream out) {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ROOT);
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        nf.setMinimumIntegerDigits(3);
        for (int i = 0; i < this.maxLevels; ++i) {
            out.println(i + "]\t" + nf.format(this.levelW[i]) + "\t" + nf.format(this.levelH[i]) + "\t" + this.levelS[i] + "\t" + this.levelS[i] * this.levelS[i]);
        }
    }

    @Override
    public int getLevelForDistance(double dist) {
        if (dist == 0.0) {
            return this.maxLevels;
        }
        for (int i = 0; i < this.maxLevels - 1; ++i) {
            if (!(dist > this.levelW[i]) || !(dist > this.levelH[i])) continue;
            return i + 1;
        }
        return this.maxLevels;
    }

    @Override
    public Cell getCell(Point p, int level) {
        ArrayList<Cell> cells = new ArrayList<Cell>(1);
        this.build(this.xmid, this.ymid, 0, cells, new BytesRef(this.maxLevels + 1), (Shape)this.ctx.makePoint(p.getX(), p.getY()), level);
        return (Cell)cells.get(0);
    }

    private void build(double x, double y, int level, List<Cell> matches, BytesRef str, Shape shape, int maxLevel) {
        assert (str.length == level);
        double w = this.levelW[level] / 2.0;
        double h = this.levelH[level] / 2.0;
        this.checkBattenberg('A', x - w, y + h, level, matches, str, shape, maxLevel);
        this.checkBattenberg('B', x + w, y + h, level, matches, str, shape, maxLevel);
        this.checkBattenberg('C', x - w, y - h, level, matches, str, shape, maxLevel);
        this.checkBattenberg('D', x + w, y - h, level, matches, str, shape, maxLevel);
    }

    protected void checkBattenberg(char c, double cx, double cy, int level, List<Cell> matches, BytesRef str, Shape shape, int maxLevel) {
        assert (str.length == level);
        assert (str.offset == 0);
        double w = this.levelW[level] / 2.0;
        double h = this.levelH[level] / 2.0;
        int strlen = str.length;
        Rectangle rectangle = this.ctx.makeRectangle(cx - w, cx + w, cy - h, cy + h);
        SpatialRelation v = shape.relate((Shape)rectangle);
        if (SpatialRelation.CONTAINS == v) {
            str.bytes[str.length++] = (byte)c;
            matches.add(new QuadCell(BytesRef.deepCopyOf(str), v.transpose()));
        } else if (SpatialRelation.DISJOINT != v) {
            str.bytes[str.length++] = (byte)c;
            int nextLevel = level + 1;
            if (nextLevel >= maxLevel) {
                matches.add(new QuadCell(BytesRef.deepCopyOf(str), v.transpose()));
            } else {
                this.build(cx, cy, nextLevel, matches, str, shape, maxLevel);
            }
        }
        str.length = strlen;
    }

    protected class QuadCell
    extends LegacyCell {
        QuadCell(byte[] bytes, int off, int len) {
            super(bytes, off, len);
        }

        QuadCell(BytesRef str, SpatialRelation shapeRel) {
            this(str.bytes, str.offset, str.length);
            this.shapeRel = shapeRel;
        }

        @Override
        protected QuadPrefixTree getGrid() {
            return QuadPrefixTree.this;
        }

        @Override
        protected int getMaxLevels() {
            return QuadPrefixTree.this.maxLevels;
        }

        @Override
        protected Collection<Cell> getSubCells() {
            BytesRef source = this.getTokenBytesNoLeaf(null);
            ArrayList<Cell> cells = new ArrayList<Cell>(4);
            cells.add(new QuadCell(this.concat(source, (byte)65), null));
            cells.add(new QuadCell(this.concat(source, (byte)66), null));
            cells.add(new QuadCell(this.concat(source, (byte)67), null));
            cells.add(new QuadCell(this.concat(source, (byte)68), null));
            return cells;
        }

        protected BytesRef concat(BytesRef source, byte b) {
            byte[] buffer = Arrays.copyOfRange(source.bytes, source.offset, source.offset + source.length + 2);
            BytesRef target = new BytesRef(buffer);
            target.length = source.length;
            target.bytes[target.length++] = b;
            return target;
        }

        @Override
        public int getSubCellsSize() {
            return 4;
        }

        @Override
        protected QuadCell getSubCell(Point p) {
            return (QuadCell)QuadPrefixTree.this.getCell(p, this.getLevel() + 1);
        }

        @Override
        public Shape getShape() {
            if (this.shape == null) {
                this.shape = this.makeShape();
            }
            return this.shape;
        }

        protected Rectangle makeShape() {
            double height;
            double width;
            BytesRef token = this.getTokenBytesNoLeaf(null);
            double xmin = QuadPrefixTree.this.xmin;
            double ymin = QuadPrefixTree.this.ymin;
            block6: for (int i = 0; i < token.length; ++i) {
                byte c = token.bytes[token.offset + i];
                switch (c) {
                    case 65: {
                        ymin += QuadPrefixTree.this.levelH[i];
                        continue block6;
                    }
                    case 66: {
                        xmin += QuadPrefixTree.this.levelW[i];
                        ymin += QuadPrefixTree.this.levelH[i];
                        continue block6;
                    }
                    case 67: {
                        continue block6;
                    }
                    case 68: {
                        xmin += QuadPrefixTree.this.levelW[i];
                        continue block6;
                    }
                    default: {
                        throw new RuntimeException("unexpected char: " + c);
                    }
                }
            }
            int len = token.length;
            if (len > 0) {
                width = QuadPrefixTree.this.levelW[len - 1];
                height = QuadPrefixTree.this.levelH[len - 1];
            } else {
                width = QuadPrefixTree.this.gridW;
                height = QuadPrefixTree.this.gridH;
            }
            return QuadPrefixTree.this.ctx.makeRectangle(xmin, xmin + width, ymin, ymin + height);
        }
    }

    public static class Factory
    extends SpatialPrefixTreeFactory {
        @Override
        protected int getLevelForDistance(double degrees) {
            QuadPrefixTree grid = new QuadPrefixTree(this.ctx, 50);
            return grid.getLevelForDistance(degrees);
        }

        @Override
        protected SpatialPrefixTree newSPT() {
            return new QuadPrefixTree(this.ctx, this.maxLevels != null ? this.maxLevels : 50);
        }
    }
}

