/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.NumberRangePrefixTree;

public class DateRangePrefixTree
extends NumberRangePrefixTree {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final Calendar DEFAULT_CAL = Calendar.getInstance(UTC, Locale.ROOT);
    public static final Calendar JAVA_UTIL_TIME_COMPAT_CAL;
    private static final int[] FIELD_BY_LEVEL;
    private static final int YEAR_LEVEL = 3;
    private static final int NUM_MYEARS = 586;
    @Deprecated
    public static final DateRangePrefixTree INSTANCE;
    private final Calendar CAL_TMP;
    private final Calendar MINCAL;
    private final Calendar MAXCAL;
    private final int BC_FIRSTYEAR;
    private final int BC_LASTYEAR;
    private final int BC_YEARS;
    private final int AD_FIRSTYEAR;
    private final int AD_LASTYEAR;
    private final int AD_YEAR_BASE;
    private final NumberRangePrefixTree.UnitNRShape minLV;
    private final NumberRangePrefixTree.UnitNRShape maxLV;
    private final NumberRangePrefixTree.UnitNRShape gregorianChangeDateLV;

    public DateRangePrefixTree(Calendar templateCal) {
        super(new int[]{586, 1000, 1000, DateRangePrefixTree.calFieldLen(templateCal, 2), DateRangePrefixTree.calFieldLen(templateCal, 5), DateRangePrefixTree.calFieldLen(templateCal, 11), DateRangePrefixTree.calFieldLen(templateCal, 12), DateRangePrefixTree.calFieldLen(templateCal, 13), DateRangePrefixTree.calFieldLen(templateCal, 14)});
        this.CAL_TMP = (Calendar)templateCal.clone();
        this.MINCAL = (Calendar)this.CAL_TMP.clone();
        this.MINCAL.setTimeInMillis(Long.MIN_VALUE);
        this.MAXCAL = (Calendar)this.CAL_TMP.clone();
        this.MAXCAL.setTimeInMillis(Long.MAX_VALUE);
        this.BC_FIRSTYEAR = this.MINCAL.getActualMaximum(1);
        this.BC_LASTYEAR = this.MINCAL.getActualMinimum(1);
        this.BC_YEARS = this.BC_FIRSTYEAR - this.BC_LASTYEAR + 1;
        this.AD_FIRSTYEAR = this.MAXCAL.getActualMinimum(1);
        this.AD_LASTYEAR = this.MAXCAL.getActualMaximum(1);
        this.AD_YEAR_BASE = ((this.BC_YEARS - 1) / 1000000 + 1) * 1000000;
        assert (this.BC_LASTYEAR == 1 && this.AD_FIRSTYEAR == 1);
        assert (586 == (this.AD_YEAR_BASE + this.AD_LASTYEAR) / 1000000 + 1);
        this.maxLV = this.toShape((Calendar)this.MAXCAL.clone());
        this.minLV = this.toShape((Calendar)this.MINCAL.clone());
        if (this.MAXCAL instanceof GregorianCalendar) {
            GregorianCalendar gCal = (GregorianCalendar)this.MAXCAL;
            this.gregorianChangeDateLV = this.toUnitShape(gCal.getGregorianChange());
        } else {
            this.gregorianChangeDateLV = null;
        }
    }

    private static int calFieldLen(Calendar cal, int field) {
        return cal.getMaximum(field) - cal.getMinimum(field) + 1;
    }

    @Override
    public int getNumSubCells(NumberRangePrefixTree.UnitNRShape lv) {
        int cmp = DateRangePrefixTree.comparePrefix(lv, this.maxLV);
        assert (cmp <= 0);
        if (cmp == 0) {
            return this.maxLV.getValAtLevel(lv.getLevel() + 1) + 1;
        }
        int n = cmp = this.gregorianChangeDateLV != null ? DateRangePrefixTree.comparePrefix(lv, this.gregorianChangeDateLV) : -1;
        if (cmp >= 0) {
            int result = this.fastSubCells(lv);
            assert (result == this.slowSubCells(lv)) : "fast/slow numSubCells inconsistency";
            return result;
        }
        return this.slowSubCells(lv);
    }

    private int fastSubCells(NumberRangePrefixTree.UnitNRShape lv) {
        if (lv.getLevel() == 4) {
            switch (lv.getValAtLevel(lv.getLevel())) {
                case 3: 
                case 5: 
                case 8: 
                case 10: {
                    return 30;
                }
                case 1: {
                    int yearAdj = lv.getValAtLevel(1) * 1000000;
                    yearAdj += lv.getValAtLevel(2) * 1000;
                    int year = (yearAdj += lv.getValAtLevel(3)) - this.AD_YEAR_BASE;
                    if (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0)) {
                        return 29;
                    }
                    return 28;
                }
            }
            return 31;
        }
        return super.getNumSubCells(lv);
    }

    private int slowSubCells(NumberRangePrefixTree.UnitNRShape lv) {
        int field = FIELD_BY_LEVEL[lv.getLevel() + 1];
        if (field == -1 || field == 1 || field >= 11) {
            return super.getNumSubCells(lv);
        }
        Calendar cal = this.toCalendar(lv);
        return cal.getActualMaximum(field) - cal.getActualMinimum(field) + 1;
    }

    public Calendar newCal() {
        return (Calendar)this.CAL_TMP.clone();
    }

    public int getTreeLevelForCalendarField(int calField) {
        for (int i = 3; i < FIELD_BY_LEVEL.length; ++i) {
            if (FIELD_BY_LEVEL[i] == calField) {
                return i;
            }
            if (FIELD_BY_LEVEL[i] <= calField) continue;
            return -1 * i;
        }
        throw new IllegalArgumentException("Bad calendar field?: " + calField);
    }

    public int getCalPrecisionField(Calendar cal) {
        int field;
        int lastField = -1;
        for (int level = 3; level < FIELD_BY_LEVEL.length && cal.isSet(field = FIELD_BY_LEVEL[level]); ++level) {
            lastField = field;
        }
        return lastField;
    }

    public void clearFieldsAfter(Calendar cal, int field) {
        int assertEra = -1;
        assert ((assertEra = ((Calendar)cal.clone()).get(0)) >= 0);
        for (int f = field + 1; f <= 14; ++f) {
            cal.clear(f);
        }
        assert (field + 1 == 0 || ((Calendar)cal.clone()).get(0) == assertEra) : "Calendar underflow";
    }

    @Override
    public NumberRangePrefixTree.UnitNRShape toUnitShape(Object value) {
        if (value instanceof Calendar) {
            return this.toShape((Calendar)value);
        }
        if (value instanceof Date) {
            Calendar cal = this.newCal();
            cal.setTime((Date)value);
            return this.toShape(cal);
        }
        throw new IllegalArgumentException("Expecting Calendar or Date but got: " + value.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberRangePrefixTree.UnitNRShape toShape(Calendar cal) {
        int calPrecField = this.getCalPrecisionField(cal);
        try {
            int[] valStack = new int[this.maxLevels];
            int len = 0;
            if (calPrecField >= 1) {
                int field;
                int year = cal.get(1);
                int yearAdj = cal.get(0) == 0 ? this.AD_YEAR_BASE - (year - 1) : this.AD_YEAR_BASE + year;
                valStack[len++] = yearAdj / 1000000;
                yearAdj -= valStack[len - 1] * 1000000;
                valStack[len++] = yearAdj / 1000;
                yearAdj -= valStack[len - 1] * 1000;
                valStack[len++] = yearAdj;
                for (int level = 4; level < FIELD_BY_LEVEL.length && (field = FIELD_BY_LEVEL[level]) <= calPrecField; ++level) {
                    valStack[len++] = cal.get(field) - cal.getActualMinimum(field);
                }
            }
            NumberRangePrefixTree.UnitNRShape unitNRShape = this.toShape(valStack, len);
            return unitNRShape;
        }
        finally {
            this.clearFieldsAfter(cal, calPrecField);
        }
    }

    @Override
    public Object toObject(NumberRangePrefixTree.UnitNRShape shape) {
        return this.toCalendar(shape);
    }

    public Calendar toCalendar(NumberRangePrefixTree.UnitNRShape lv) {
        if (lv.getLevel() == 0) {
            return this.newCal();
        }
        if (DateRangePrefixTree.comparePrefix(lv, this.minLV) <= 0) {
            return (Calendar)this.MINCAL.clone();
        }
        assert (DateRangePrefixTree.comparePrefix(lv, this.maxLV) <= 0);
        Calendar cal = this.newCal();
        int yearAdj = lv.getValAtLevel(1) * 1000000;
        if (lv.getLevel() > 1) {
            yearAdj += lv.getValAtLevel(2) * 1000;
            if (lv.getLevel() > 2) {
                yearAdj += lv.getValAtLevel(3);
            }
        }
        if (yearAdj > this.AD_YEAR_BASE) {
            cal.set(0, 1);
            cal.set(1, yearAdj - this.AD_YEAR_BASE);
        } else {
            cal.set(0, 0);
            cal.set(1, this.AD_YEAR_BASE - yearAdj + 1);
        }
        for (int level = 4; level <= lv.getLevel(); ++level) {
            int field = FIELD_BY_LEVEL[level];
            cal.set(field, lv.getValAtLevel(level) + cal.getActualMinimum(field));
        }
        assert (yearAdj > this.AD_YEAR_BASE || ((Calendar)cal.clone()).get(0) == 0) : "ERA / YEAR underflow";
        return cal;
    }

    @Override
    protected String toString(NumberRangePrefixTree.UnitNRShape lv) {
        return this.toString(this.toCalendar(lv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Calendar cal) {
        int calPrecField = this.getCalPrecisionField(cal);
        if (calPrecField == -1) {
            return "*";
        }
        try {
            StringBuilder builder = new StringBuilder("yyyy-MM-dd'T'HH:mm:ss.SSS".length());
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                if (--year > 0) {
                    builder.append('-');
                }
            } else if (year > 9999) {
                builder.append('+');
            }
            this.appendPadded(builder, year, (short)4);
            if (calPrecField >= 2) {
                builder.append('-');
                this.appendPadded(builder, cal.get(2) + 1, (short)2);
            }
            if (calPrecField >= 5) {
                builder.append('-');
                this.appendPadded(builder, cal.get(5), (short)2);
            }
            if (calPrecField >= 11) {
                builder.append('T');
                this.appendPadded(builder, cal.get(11), (short)2);
            }
            if (calPrecField >= 12) {
                builder.append(':');
                this.appendPadded(builder, cal.get(12), (short)2);
            }
            if (calPrecField >= 13) {
                builder.append(':');
                this.appendPadded(builder, cal.get(13), (short)2);
            }
            if (calPrecField >= 14 && cal.get(14) > 0) {
                builder.append('.');
                this.appendPadded(builder, cal.get(14), (short)3);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            this.clearFieldsAfter(cal, calPrecField);
        }
    }

    private void appendPadded(StringBuilder builder, int integer, short positions) {
        assert (integer >= 0 && positions >= 1 && positions <= 4);
        int preBuilderLen = builder.length();
        int intStrLen = integer > 999 ? 4 : (integer > 99 ? 3 : (integer > 9 ? 2 : 1));
        for (int i = 0; i < positions - intStrLen; ++i) {
            builder.append('0');
        }
        builder.append(integer);
    }

    @Override
    protected NumberRangePrefixTree.UnitNRShape parseUnitShape(String str) throws ParseException {
        return this.toShape(this.parseCalendar(str));
    }

    public Calendar parseCalendar(String str) throws ParseException {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("str is null or blank");
        }
        Calendar cal = this.newCal();
        if (str.equals("*")) {
            return cal;
        }
        int offset = 0;
        try {
            int year;
            int lastOffset = str.charAt(str.length() - 1) == 'Z' ? str.length() - 1 : str.length();
            int hyphenIdx = str.indexOf(45, 1);
            if (hyphenIdx < 0) {
                hyphenIdx = lastOffset;
            }
            cal.set(0, (year = Integer.parseInt(str.substring(offset, hyphenIdx))) <= 0 ? 0 : 1);
            cal.set(1, year <= 0 ? -1 * year + 1 : year);
            offset = hyphenIdx + 1;
            if (lastOffset < offset) {
                return cal;
            }
            cal.set(2, Integer.parseInt(str.substring(offset, offset + 2)) - 1);
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(5, Integer.parseInt(str.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(11, Integer.parseInt(str.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(12, Integer.parseInt(str.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(13, Integer.parseInt(str.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(14, Integer.parseInt(str.substring(offset, offset + 3)));
            if (lastOffset == (offset += 3)) {
                return cal;
            }
        }
        catch (Exception e) {
            ParseException pe = new ParseException("Improperly formatted date: " + str, offset);
            pe.initCause(e);
            throw pe;
        }
        throw new ParseException("Improperly formatted date: " + str, offset);
    }

    static {
        DEFAULT_CAL.clear();
        GregorianCalendar cal = new GregorianCalendar(UTC, Locale.ROOT);
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.clear();
        JAVA_UTIL_TIME_COMPAT_CAL = cal;
        FIELD_BY_LEVEL = new int[]{-1, -1, -1, 1, 2, 5, 11, 12, 13, 14};
        INSTANCE = new DateRangePrefixTree(DEFAULT_CAL);
    }
}

