/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;

public class TransportRequestOptions {
    private final TimeValue timeout;
    private final boolean compress;
    private final Type type;
    public static final TransportRequestOptions EMPTY = new Builder().build();

    private TransportRequestOptions(TimeValue timeout, boolean compress, Type type) {
        this.timeout = timeout;
        this.compress = compress;
        this.type = type;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public boolean compress() {
        return this.compress;
    }

    public Type type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TransportRequestOptions options) {
        return new Builder().withTimeout(options.timeout).withCompress(options.compress).withType(options.type());
    }

    public static class Builder {
        private TimeValue timeout;
        private boolean compress;
        private Type type = Type.REG;

        private Builder() {
        }

        public Builder withTimeout(long timeout) {
            return this.withTimeout(TimeValue.timeValueMillis(timeout));
        }

        public Builder withTimeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withCompress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder withType(Type type) {
            this.type = type;
            return this;
        }

        public TransportRequestOptions build() {
            return new TransportRequestOptions(this.timeout, this.compress, this.type);
        }
    }

    public static enum Type {
        RECOVERY,
        BULK,
        REG,
        STATE,
        PING;

    }
}

