/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TcpChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TcpTransport;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportResponseOptions;

public final class TcpTransportChannel
implements TransportChannel {
    private final TcpTransport transport;
    private final Version version;
    private final Set<String> features;
    private final String action;
    private final long requestId;
    private final String profileName;
    private final long reservedBytes;
    private final AtomicBoolean released = new AtomicBoolean();
    private final String channelType;
    private final TcpChannel channel;
    private Exception releaseBy;

    TcpTransportChannel(TcpTransport transport, TcpChannel channel, String channelType, String action, long requestId, Version version, Set<String> features, String profileName, long reservedBytes) {
        this.version = version;
        this.features = features;
        this.channel = channel;
        this.transport = transport;
        this.action = action;
        this.requestId = requestId;
        this.profileName = profileName;
        this.reservedBytes = reservedBytes;
        this.channelType = channelType;
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.sendResponse(response, TransportResponseOptions.EMPTY);
    }

    @Override
    public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
        try {
            this.transport.sendResponse(this.version, this.features, this.channel, response, this.requestId, this.action, options);
        }
        finally {
            this.release(false);
        }
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        try {
            this.transport.sendErrorResponse(this.version, this.features, this.channel, exception, this.requestId, this.action);
        }
        finally {
            this.release(true);
        }
    }

    private void release(boolean isExceptionResponse) {
        if (this.released.compareAndSet(false, true)) {
            assert ((this.releaseBy = new Exception()) != null);
            this.transport.getInFlightRequestBreaker().addWithoutBreaking(-this.reservedBytes);
        } else if (!isExceptionResponse) {
            throw new IllegalStateException("reserved bytes are already released", this.releaseBy);
        }
    }

    @Override
    public String getChannelType() {
        return this.channelType;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public TcpChannel getChannel() {
        return this.channel;
    }
}

