/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.compress.CompressorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.Streams;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.BytesStream;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.core.internal.io.IOUtils;

final class CompressibleBytesOutputStream
extends StreamOutput {
    private final StreamOutput stream;
    private final BytesStream bytesStreamOutput;
    private final boolean shouldCompress;

    CompressibleBytesOutputStream(BytesStream bytesStreamOutput, boolean shouldCompress) throws IOException {
        this.bytesStreamOutput = bytesStreamOutput;
        this.shouldCompress = shouldCompress;
        this.stream = shouldCompress ? CompressorFactory.COMPRESSOR.streamOutput(Streams.flushOnCloseStream(bytesStreamOutput)) : bytesStreamOutput;
    }

    BytesReference materializeBytes() throws IOException {
        if (this.shouldCompress) {
            this.stream.close();
        }
        return this.bytesStreamOutput.bytes();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.stream.writeBytes(b, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.stream == this.bytesStreamOutput) {
            assert (!this.shouldCompress) : "If the streams are the same we should not be compressing";
            IOUtils.close(this.stream);
        } else {
            assert (this.shouldCompress) : "If the streams are different we should be compressing";
            IOUtils.close(this.stream, this.bytesStreamOutput);
        }
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }
}

