/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregationBuilder;

public abstract class BucketMetricsParser
implements PipelineAggregator.Parser {
    public static final ParseField FORMAT = new ParseField("format", new String[0]);

    @Override
    public final BucketMetricsPipelineAggregationBuilder<?> parse(String pipelineAggregatorName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        BucketHelpers.GapPolicy gapPolicy = null;
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (FORMAT.match(currentFieldName, parser.getDeprecationHandler())) {
                    format = parser.text();
                    continue;
                }
                if (BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    bucketsPaths = new String[]{parser.text()};
                    continue;
                }
                if (GAP_POLICY.match(currentFieldName, parser.getDeprecationHandler())) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(parser.text(), parser.getTokenLocation());
                    continue;
                }
                this.parseToken(pipelineAggregatorName, parser, currentFieldName, token, params);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[paths.size()]);
                    continue;
                }
                this.parseToken(pipelineAggregatorName, parser, currentFieldName, token, params);
                continue;
            }
            this.parseToken(pipelineAggregatorName, parser, currentFieldName, token, params);
        }
        if (bucketsPaths == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + BUCKETS_PATH.getPreferredName() + "] for aggregation [" + pipelineAggregatorName + "]", new Object[0]);
        }
        BucketMetricsPipelineAggregationBuilder<?> factory = this.buildFactory(pipelineAggregatorName, (String)bucketsPaths[0], params);
        if (format != null) {
            factory.format(format);
        }
        if (gapPolicy != null) {
            factory.gapPolicy(gapPolicy);
        }
        assert (factory != null);
        return factory;
    }

    protected abstract BucketMetricsPipelineAggregationBuilder<?> buildFactory(String var1, String var2, Map<String, Object> var3);

    protected boolean token(XContentParser parser, String field, XContentParser.Token token, Map<String, Object> params) throws IOException {
        return false;
    }

    private void parseToken(String aggregationName, XContentParser parser, String currentFieldName, XContentParser.Token currentToken, Map<String, Object> params) throws IOException {
        if (!this.token(parser, currentFieldName, currentToken, params)) {
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)currentToken) + " [" + currentFieldName + "] in [" + aggregationName + "]", new Object[0]);
        }
    }
}

