/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.plugins.ScriptPlugin;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ExecutableScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.FilterScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptEngine;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.SearchScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.SimilarityScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.SimilarityWeightScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.TemplateScript;

public class ScriptModule {
    public static final Map<String, ScriptContext<?>> CORE_CONTEXTS = Stream.of(SearchScript.CONTEXT, SearchScript.AGGS_CONTEXT, ExecutableScript.CONTEXT, ExecutableScript.AGGS_CONTEXT, ExecutableScript.UPDATE_CONTEXT, ExecutableScript.INGEST_CONTEXT, FilterScript.CONTEXT, SimilarityScript.CONTEXT, SimilarityWeightScript.CONTEXT, TemplateScript.CONTEXT).collect(Collectors.toMap(c -> c.name, Function.identity()));
    private final ScriptService scriptService;

    public ScriptModule(Settings settings, List<ScriptPlugin> scriptPlugins) {
        HashMap<String, ScriptEngine> engines = new HashMap<String, ScriptEngine>();
        HashMap contexts = new HashMap(CORE_CONTEXTS);
        for (ScriptPlugin plugin : scriptPlugins) {
            for (ScriptContext context : plugin.getContexts()) {
                ScriptContext oldContext = contexts.put(context.name, context);
                if (oldContext == null) continue;
                throw new IllegalArgumentException("Context name [" + context.name + "] defined twice");
            }
        }
        for (ScriptPlugin plugin : scriptPlugins) {
            ScriptEngine existing;
            ScriptEngine engine = plugin.getScriptEngine(settings, contexts.values());
            if (engine == null || (existing = engines.put(engine.getType(), engine)) == null) continue;
            throw new IllegalArgumentException("scripting language [" + engine.getType() + "] defined for engine [" + existing.getClass().getName() + "] and [" + engine.getClass().getName());
        }
        this.scriptService = new ScriptService(settings, Collections.unmodifiableMap(engines), Collections.unmodifiableMap(contexts));
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void registerClusterSettingsListeners(ClusterSettings clusterSettings) {
        this.scriptService.registerClusterSettingsListeners(clusterSettings);
    }
}

