/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.repositories.blobstore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.blobstore.BlobContainer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesArray;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.compress.CompressorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.core.internal.io.Streams;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.gateway.CorruptStateException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.repositories.blobstore.BlobStoreFormat;

public class ChecksumBlobStoreFormat<T extends ToXContent>
extends BlobStoreFormat<T> {
    private static final String TEMP_FILE_PREFIX = "pending-";
    private static final XContentType DEFAULT_X_CONTENT_TYPE = XContentType.SMILE;
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    protected final XContentType xContentType;
    protected final boolean compress;
    private final String codec;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader, NamedXContentRegistry namedXContentRegistry, boolean compress, XContentType xContentType) {
        super(blobNameFormat, reader, namedXContentRegistry);
        this.xContentType = xContentType;
        this.compress = compress;
        this.codec = codec;
    }

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader, NamedXContentRegistry namedXContentRegistry, boolean compress) {
        this(codec, blobNameFormat, reader, namedXContentRegistry, compress, DEFAULT_X_CONTENT_TYPE);
    }

    /*
     * Loose catch block
     */
    @Override
    public T readBlob(BlobContainer blobContainer, String blobName) throws IOException {
        Throwable throwable = null;
        try (InputStream inputStream = blobContainer.readBlob(blobName);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.copy(inputStream, out);
            byte[] bytes = out.toByteArray();
            String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
            ByteArrayIndexInput indexInput = new ByteArrayIndexInput(resourceDesc, bytes);
            Throwable throwable2 = null;
            CodecUtil.checksumEntireFile(indexInput);
            CodecUtil.checkHeader(indexInput, this.codec, 1, 1);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            BytesArray bytesReference = new BytesArray(bytes, (int)filePointer, (int)contentSize);
            Object t = this.read(bytesReference);
            ChecksumBlobStoreFormat.$closeResource(throwable2, indexInput);
            return t;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                ChecksumBlobStoreFormat.$closeResource(throwable2, indexInput);
                                throw throwable4;
                            }
                        }
                        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                            throw new CorruptStateException(ex);
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
            }
        }
    }

    public void writeAtomic(T obj, BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        String tempBlobName = this.tempBlobName(name);
        this.writeBlob(obj, blobContainer, tempBlobName);
        try {
            blobContainer.move(tempBlobName, blobName);
        }
        catch (IOException ex) {
            try {
                blobContainer.deleteBlob(tempBlobName);
            }
            catch (Exception e) {
                ex.addSuppressed(e);
            }
            throw ex;
        }
    }

    public void write(T obj, BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        this.writeBlob(obj, blobContainer, blobName);
    }

    protected void writeBlob(T obj, BlobContainer blobContainer, String blobName) throws IOException {
        BytesReference bytes = this.write(obj);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String resourceDesc = "ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")";
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput(resourceDesc, blobName, byteArrayOutputStream, 4096);){
                CodecUtil.writeHeader(indexOutput, this.codec, 1);
                try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream(indexOutput){

                    @Override
                    public void close() throws IOException {
                    }
                };){
                    bytes.writeTo(indexOutputOutputStream);
                }
                CodecUtil.writeFooter(indexOutput);
            }
            BytesArray bytesArray = new BytesArray(byteArrayOutputStream.toByteArray());
            try (StreamInput stream = bytesArray.streamInput();){
                blobContainer.writeBlob(blobName, stream, bytesArray.length());
            }
        }
    }

    public boolean isTempBlobName(String blobName) {
        return blobName.startsWith(TEMP_FILE_PREFIX);
    }

    protected BytesReference write(T obj) throws IOException {
        try (BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();){
            if (this.compress) {
                try (StreamOutput compressedStreamOutput = CompressorFactory.COMPRESSOR.streamOutput(bytesStreamOutput);){
                    this.write(obj, compressedStreamOutput);
                }
            } else {
                this.write(obj, bytesStreamOutput);
            }
            BytesReference bytesReference = bytesStreamOutput.bytes();
            return bytesReference;
        }
    }

    protected void write(T obj, StreamOutput streamOutput) throws IOException {
        try (XContentBuilder builder = XContentFactory.contentBuilder(this.xContentType, streamOutput);){
            builder.startObject();
            obj.toXContent(builder, SNAPSHOT_ONLY_FORMAT_PARAMS);
            builder.endObject();
        }
    }

    protected String tempBlobName(String name) {
        return TEMP_FILE_PREFIX + String.format(Locale.ROOT, this.blobNameFormat, name);
    }
}

