/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.monitor.fs;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterInfoService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.SingleObjectCache;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.NodeEnvironment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.monitor.fs.FsInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.monitor.fs.FsProbe;

public class FsService
extends AbstractComponent {
    private final FsProbe probe;
    private final TimeValue refreshInterval;
    private final SingleObjectCache<FsInfo> cache;
    private final ClusterInfoService clusterInfoService;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.fs.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public FsService(Settings settings, NodeEnvironment nodeEnvironment, ClusterInfoService clusterInfoService) {
        super(settings);
        this.probe = new FsProbe(settings, nodeEnvironment);
        this.clusterInfoService = clusterInfoService;
        this.refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.logger.debug("using refresh_interval [{}]", (Object)this.refreshInterval);
        this.cache = new FsInfoCache(this.refreshInterval, FsService.stats(this.probe, null, this.logger, null));
    }

    public FsInfo stats() {
        return this.cache.getOrRefresh();
    }

    private static FsInfo stats(FsProbe probe, FsInfo initialValue, Logger logger, @Nullable ClusterInfo clusterInfo) {
        try {
            return probe.stats(initialValue, clusterInfo);
        }
        catch (IOException e) {
            logger.debug("unexpected exception reading filesystem info", (Throwable)e);
            return null;
        }
    }

    private class FsInfoCache
    extends SingleObjectCache<FsInfo> {
        private final FsInfo initialValue;

        FsInfoCache(TimeValue interval, FsInfo initialValue) {
            super(interval, initialValue);
            this.initialValue = initialValue;
        }

        @Override
        protected FsInfo refresh() {
            return FsService.stats(FsService.this.probe, this.initialValue, FsService.this.logger, FsService.this.clusterInfoService.getClusterInfo());
        }
    }
}

