/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRefIterator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.UUIDs;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.Loggers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.CancellableThreads;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MapperException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.seqno.ReplicationTracker;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.IndexShardState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store.Store;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.store.StoreFileMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog.Translog;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.recovery.RecoveryState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.recovery.RecoveryTargetHandler;

public class RecoveryTarget
extends AbstractRefCounted
implements RecoveryTargetHandler {
    private final Logger logger;
    private static final AtomicLong idGenerator = new AtomicLong();
    private static final String RECOVERY_PREFIX = "recovery.";
    private final ShardId shardId;
    private final long recoveryId;
    private final IndexShard indexShard;
    private final DiscoveryNode sourceNode;
    private final String tempFilePrefix;
    private final Store store;
    private final PeerRecoveryTargetService.RecoveryListener listener;
    private final LongConsumer ensureClusterStateVersionCallback;
    private final AtomicBoolean finished = new AtomicBoolean();
    private final ConcurrentMap<String, IndexOutput> openIndexOutputs = ConcurrentCollections.newConcurrentMap();
    private final CancellableThreads cancellableThreads;
    private volatile long lastAccessTime = System.nanoTime();
    private final CountDownLatch closedLatch = new CountDownLatch(1);
    private final Map<String, String> tempFileNames = ConcurrentCollections.newConcurrentMap();

    public RecoveryTarget(IndexShard indexShard, DiscoveryNode sourceNode, PeerRecoveryTargetService.RecoveryListener listener, LongConsumer ensureClusterStateVersionCallback) {
        super("recovery_status");
        this.cancellableThreads = new CancellableThreads();
        this.recoveryId = idGenerator.incrementAndGet();
        this.listener = listener;
        this.logger = Loggers.getLogger(this.getClass(), indexShard.indexSettings().getSettings(), indexShard.shardId(), new String[0]);
        this.indexShard = indexShard;
        this.sourceNode = sourceNode;
        this.shardId = indexShard.shardId();
        this.tempFilePrefix = RECOVERY_PREFIX + UUIDs.randomBase64UUID() + ".";
        this.store = indexShard.store();
        this.ensureClusterStateVersionCallback = ensureClusterStateVersionCallback;
        this.store.incRef();
        indexShard.recoveryStats().incCurrentAsTarget();
    }

    public RecoveryTarget retryCopy() {
        return new RecoveryTarget(this.indexShard, this.sourceNode, this.listener, this.ensureClusterStateVersionCallback);
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public IndexShard indexShard() {
        this.ensureRefCount();
        return this.indexShard;
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public RecoveryState state() {
        return this.indexShard.recoveryState();
    }

    public CancellableThreads cancellableThreads() {
        return this.cancellableThreads;
    }

    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime() {
        this.lastAccessTime = System.nanoTime();
    }

    public Store store() {
        this.ensureRefCount();
        return this.store;
    }

    public RecoveryState.Stage stage() {
        return this.state().getStage();
    }

    public void renameAllTempFiles() throws IOException {
        this.ensureRefCount();
        this.store.renameTempFilesSafe(this.tempFileNames);
    }

    boolean resetRecovery(CancellableThreads newTargetCancellableThreads) throws IOException {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("reset of recovery with shard {} and id [{}]", (Object)this.shardId, (Object)this.recoveryId);
            }
            finally {
                this.decRef();
            }
            try {
                newTargetCancellableThreads.execute(this.closedLatch::await);
            }
            catch (CancellableThreads.ExecutionCancelledException e) {
                this.logger.trace("new recovery target cancelled for shard {} while waiting on old recovery target with id [{}] to close", (Object)this.shardId, (Object)this.recoveryId);
                return false;
            }
            RecoveryState.Stage stage = this.indexShard.recoveryState().getStage();
            if (this.indexShard.recoveryState().getPrimary() && (stage == RecoveryState.Stage.FINALIZE || stage == RecoveryState.Stage.DONE)) {
                assert (stage != RecoveryState.Stage.DONE) : "recovery should not have completed when it's being reset";
                throw new IllegalStateException("cannot reset recovery as previous attempt made it past finalization step");
            }
            this.indexShard.performRecoveryRestart();
            return true;
        }
        return false;
    }

    public void cancel(String reason) {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("recovery canceled (reason: [{}])", (Object)reason);
                this.cancellableThreads.cancel(reason);
            }
            finally {
                this.decRef();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(RecoveryFailedException e, boolean sendShardFailure) {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.notifyListener(e, sendShardFailure);
            }
            finally {
                try {
                    this.cancellableThreads.cancel("failed recovery [" + ExceptionsHelper.stackTrace(e) + "]");
                }
                finally {
                    this.decRef();
                }
            }
        }
    }

    public void notifyListener(RecoveryFailedException e, boolean sendShardFailure) {
        this.listener.onRecoveryFailure(this.state(), e, sendShardFailure);
    }

    public void markAsDone() {
        if (this.finished.compareAndSet(false, true)) {
            assert (this.tempFileNames.isEmpty()) : "not all temporary files are renamed";
            try {
                this.indexShard.postRecovery("peer recovery done");
            }
            finally {
                this.decRef();
            }
            this.listener.onRecoveryDone(this.state());
        }
    }

    public String getTempNameForFile(String origFile) {
        return this.tempFilePrefix + origFile;
    }

    public IndexOutput getOpenIndexOutput(String key) {
        this.ensureRefCount();
        return (IndexOutput)this.openIndexOutputs.get(key);
    }

    public IndexOutput removeOpenIndexOutputs(String name) {
        this.ensureRefCount();
        return (IndexOutput)this.openIndexOutputs.remove(name);
    }

    public IndexOutput openAndPutIndexOutput(String fileName, StoreFileMetaData metaData, Store store) throws IOException {
        this.ensureRefCount();
        String tempFileName = this.getTempNameForFile(fileName);
        if (this.tempFileNames.containsKey(tempFileName)) {
            throw new IllegalStateException("output for file [" + fileName + "] has already been created");
        }
        this.tempFileNames.put(tempFileName, fileName);
        IndexOutput indexOutput = store.createVerifyingOutput(tempFileName, metaData, IOContext.DEFAULT);
        this.openIndexOutputs.put(fileName, indexOutput);
        return indexOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeInternal() {
        try {
            Iterator iterator = this.openIndexOutputs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.logger.trace("closing IndexOutput file [{}]", entry.getValue());
                try {
                    ((IndexOutput)entry.getValue()).close();
                }
                catch (Exception e) {
                    this.logger.debug(() -> new ParameterizedMessage("error while closing recovery output [{}]", entry.getValue()), (Throwable)e);
                }
                iterator.remove();
            }
            for (String file : this.tempFileNames.keySet()) {
                this.logger.trace("cleaning temporary file [{}]", (Object)file);
                this.store.deleteQuiet(file);
            }
        }
        finally {
            this.store.decRef();
            this.indexShard.recoveryStats().decCurrentAsTarget();
            this.closedLatch.countDown();
        }
    }

    public String toString() {
        return this.shardId + " [" + this.recoveryId + "]";
    }

    private void ensureRefCount() {
        if (this.refCount() <= 0) {
            throw new ElasticsearchException("RecoveryStatus is used but it's refcount is 0. Probably a mismatch between incRef/decRef calls", new Object[0]);
        }
    }

    @Override
    public void prepareForTranslogOperations(boolean fileBasedRecovery, int totalTranslogOps) throws IOException {
        if (fileBasedRecovery && this.indexShard.indexSettings().getIndexVersionCreated().before(Version.V_6_0_0)) {
            this.store.ensureIndexHas6xCommitTags();
        }
        this.state().getTranslog().totalOperations(totalTranslogOps);
        this.indexShard().openEngineAndSkipTranslogRecovery();
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint) throws IOException {
        IndexShard indexShard = this.indexShard();
        indexShard.updateGlobalCheckpointOnReplica(globalCheckpoint, "finalizing recovery");
        indexShard.sync();
        indexShard.finalizeRecovery();
    }

    @Override
    public void ensureClusterStateVersion(long clusterStateVersion) {
        this.ensureClusterStateVersionCallback.accept(clusterStateVersion);
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        this.indexShard.activateWithPrimaryContext(primaryContext);
    }

    @Override
    public long indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps) throws IOException {
        RecoveryState.Translog translog = this.state().getTranslog();
        translog.totalOperations(totalTranslogOps);
        assert (this.indexShard().recoveryState() == this.state());
        if (this.indexShard().state() != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.indexShard().state());
        }
        for (Translog.Operation operation : operations) {
            Engine.Result result = this.indexShard().applyTranslogOperation(operation, Engine.Operation.Origin.PEER_RECOVERY);
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new MapperException("mapping updates are not allowed [" + operation + "]");
            }
            assert (result.getFailure() == null) : "unexpected failure while replicating translog entry: " + result.getFailure();
            ExceptionsHelper.reThrowIfNotNull(result.getFailure());
        }
        translog.incrementRecoveredOperations(operations.size());
        this.indexShard().sync();
        this.indexShard().afterWriteOperation();
        return this.indexShard().getLocalCheckpoint();
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps) {
        int i;
        RecoveryState.Index index = this.state().getIndex();
        for (i = 0; i < phase1ExistingFileNames.size(); ++i) {
            index.addFileDetail(phase1ExistingFileNames.get(i), phase1ExistingFileSizes.get(i), true);
        }
        for (i = 0; i < phase1FileNames.size(); ++i) {
            index.addFileDetail(phase1FileNames.get(i), phase1FileSizes.get(i), false);
        }
        this.state().getTranslog().totalOperations(totalTranslogOps);
        this.state().getTranslog().totalOperationsOnStart(totalTranslogOps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanFiles(int totalTranslogOps, Store.MetadataSnapshot sourceMetaData) throws IOException {
        this.state().getTranslog().totalOperations(totalTranslogOps);
        this.renameAllTempFiles();
        Store store = this.store();
        store.incRef();
        try {
            store.cleanupAndVerify("recovery CleanFilesRequestHandler", sourceMetaData);
            String translogUUID = Translog.createEmptyTranslog(this.indexShard.shardPath().resolveTranslog(), -2L, this.shardId, this.indexShard.getPrimaryTerm());
            store.associateIndexWithNewTranslog(translogUUID);
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            try {
                try {
                    store.removeCorruptionMarker();
                }
                finally {
                    Lucene.cleanLuceneIndex(store.directory());
                }
            }
            catch (Exception e) {
                this.logger.debug("Failed to clean lucene index", (Throwable)e);
                ex.addSuppressed(e);
            }
            RecoveryFailedException rfe = new RecoveryFailedException(this.state(), "failed to clean after recovery", (Throwable)ex);
            this.fail(rfe, true);
            throw rfe;
        }
        catch (Exception ex) {
            RecoveryFailedException rfe = new RecoveryFailedException(this.state(), "failed to clean after recovery", (Throwable)ex);
            this.fail(rfe, true);
            throw rfe;
        }
        finally {
            store.decRef();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFileChunk(StoreFileMetaData fileMetaData, long position, BytesReference content, boolean lastChunk, int totalTranslogOps) throws IOException {
        BytesRef scratch;
        Store store = this.store();
        String name = fileMetaData.name();
        this.state().getTranslog().totalOperations(totalTranslogOps);
        RecoveryState.Index indexState = this.state().getIndex();
        IndexOutput indexOutput = position == 0L ? this.openAndPutIndexOutput(name, fileMetaData, store) : this.getOpenIndexOutput(name);
        BytesRefIterator iterator = content.iterator();
        while ((scratch = iterator.next()) != null) {
            indexOutput.writeBytes(scratch.bytes, scratch.offset, scratch.length);
        }
        indexState.addRecoveredBytesToFile(name, content.length());
        if (indexOutput.getFilePointer() >= fileMetaData.length() || lastChunk) {
            try {
                Store.verify(indexOutput);
            }
            finally {
                indexOutput.close();
            }
            String temporaryFileName = this.getTempNameForFile(name);
            assert (Arrays.asList(store.directory().listAll()).contains(temporaryFileName)) : "expected: [" + temporaryFileName + "] in " + Arrays.toString(store.directory().listAll());
            store.directory().sync(Collections.singleton(temporaryFileName));
            IndexOutput remove = this.removeOpenIndexOutputs(name);
            assert (remove == null || remove == indexOutput);
        }
    }

    Path translogLocation() {
        return this.indexShard().shardPath().resolveTranslog();
    }
}

