/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.analysis.AnalysisModule;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public abstract class PreConfiguredAnalysisComponent<T>
implements AnalysisModule.AnalysisProvider<T> {
    private final String name;
    private final PreBuiltCacheFactory.PreBuiltCache<T> cache;

    protected PreConfiguredAnalysisComponent(String name, PreBuiltCacheFactory.CachingStrategy cache) {
        this.name = name;
        this.cache = PreBuiltCacheFactory.getCache(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        Version versionCreated = Version.indexCreated(settings);
        PreConfiguredAnalysisComponent preConfiguredAnalysisComponent = this;
        synchronized (preConfiguredAnalysisComponent) {
            T factory = this.cache.get(versionCreated);
            if (factory == null) {
                factory = this.create(versionCreated);
                this.cache.put(versionCreated, factory);
            }
            return factory;
        }
    }

    public String getName() {
        return this.name;
    }

    protected abstract T create(Version var1);
}

