/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Tokenizer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.CharMatcher;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.NGramTokenizerFactory;

public class EdgeNGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final CharMatcher matcher;

    public EdgeNGramTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.minGram = settings.getAsInt("min_gram", 1);
        this.maxGram = settings.getAsInt("max_gram", 2);
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings.getAsList("token_chars"));
    }

    @Override
    public Tokenizer create() {
        if (this.matcher == null) {
            return new EdgeNGramTokenizer(this.minGram, this.maxGram);
        }
        return new EdgeNGramTokenizer(this.minGram, this.maxGram){

            @Override
            protected boolean isTokenChar(int chr) {
                return EdgeNGramTokenizerFactory.this.matcher.isTokenChar(chr);
            }
        };
    }
}

