/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilderExtension;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentGenerator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;

public final class XContentBuilder
implements Closeable,
Flushable {
    private static final Map<Class<?>, Writer> WRITERS;
    private static final Map<Class<?>, HumanReadableTransformer> HUMAN_READABLE_TRANSFORMERS;
    private static final Map<Class<?>, Function<Object, Object>> DATE_TRANSFORMERS;
    private final XContentGenerator generator;
    private final OutputStream bos;
    private boolean humanReadable = false;

    public static XContentBuilder builder(XContent xContent) throws IOException {
        return new XContentBuilder(xContent, new ByteArrayOutputStream());
    }

    public static XContentBuilder builder(XContent xContent, Set<String> includes, Set<String> excludes) throws IOException {
        return new XContentBuilder(xContent, new ByteArrayOutputStream(), includes, excludes);
    }

    public XContentBuilder(XContent xContent, OutputStream bos) throws IOException {
        this(xContent, bos, Collections.emptySet(), Collections.emptySet());
    }

    public XContentBuilder(XContent xContent, OutputStream bos, Set<String> includes) throws IOException {
        this(xContent, bos, includes, Collections.emptySet());
    }

    public XContentBuilder(XContent xContent, OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        this.bos = os;
        this.generator = xContent.createGenerator(this.bos, includes, excludes);
    }

    public XContentType contentType() {
        return this.generator.contentType();
    }

    public OutputStream getOutputStream() {
        return this.bos;
    }

    public XContentBuilder prettyPrint() {
        this.generator.usePrettyPrint();
        return this;
    }

    public boolean isPrettyPrint() {
        return this.generator.isPrettyPrint();
    }

    public XContentBuilder lfAtEnd() {
        this.generator.usePrintLineFeedAtEnd();
        return this;
    }

    public XContentBuilder humanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    public boolean humanReadable() {
        return this.humanReadable;
    }

    public XContentBuilder startObject() throws IOException {
        this.generator.writeStartObject();
        return this;
    }

    public XContentBuilder startObject(String name) throws IOException {
        return this.field(name).startObject();
    }

    public XContentBuilder endObject() throws IOException {
        this.generator.writeEndObject();
        return this;
    }

    public XContentBuilder startArray() throws IOException {
        this.generator.writeStartArray();
        return this;
    }

    public XContentBuilder startArray(String name) throws IOException {
        return this.field(name).startArray();
    }

    public XContentBuilder endArray() throws IOException {
        this.generator.writeEndArray();
        return this;
    }

    public XContentBuilder field(String name) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeFieldName(name);
        return this;
    }

    public XContentBuilder nullField(String name) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNullField(name);
        return this;
    }

    public XContentBuilder nullValue() throws IOException {
        this.generator.writeNull();
        return this;
    }

    public XContentBuilder field(String name, Boolean value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (boolean)value);
    }

    public XContentBuilder field(String name, boolean value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeBooleanField(name, value);
        return this;
    }

    public XContentBuilder array(String name, boolean[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(boolean[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (boolean b : values) {
            this.value(b);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Boolean value) throws IOException {
        return value == null ? this.nullValue() : this.value((boolean)value);
    }

    public XContentBuilder value(boolean value) throws IOException {
        this.generator.writeBoolean(value);
        return this;
    }

    public XContentBuilder field(String name, Byte value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (byte)value);
    }

    public XContentBuilder field(String name, byte value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder value(Byte value) throws IOException {
        return value == null ? this.nullValue() : this.value((byte)value);
    }

    public XContentBuilder value(byte value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Double value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (double)value);
    }

    public XContentBuilder field(String name, double value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, double[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(double[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (double b : values) {
            this.value(b);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Double value) throws IOException {
        return value == null ? this.nullValue() : this.value((double)value);
    }

    public XContentBuilder value(double value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Float value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, value.floatValue());
    }

    public XContentBuilder field(String name, float value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, float[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(float[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (float f : values) {
            this.value(f);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Float value) throws IOException {
        return value == null ? this.nullValue() : this.value(value.floatValue());
    }

    public XContentBuilder value(float value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Integer value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (int)value);
    }

    public XContentBuilder field(String name, int value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, int[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(int[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (int i : values) {
            this.value(i);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Integer value) throws IOException {
        return value == null ? this.nullValue() : this.value((int)value);
    }

    public XContentBuilder value(int value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Long value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (long)value);
    }

    public XContentBuilder field(String name, long value) throws IOException {
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeNumberField(name, value);
        return this;
    }

    public XContentBuilder array(String name, long[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(long[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (long l : values) {
            this.value(l);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Long value) throws IOException {
        return value == null ? this.nullValue() : this.value((long)value);
    }

    public XContentBuilder value(long value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Short value) throws IOException {
        return value == null ? this.nullField(name) : this.field(name, (short)value);
    }

    public XContentBuilder field(String name, short value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder array(String name, short[] values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(short[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (short s : values) {
            this.value(s);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(Short value) throws IOException {
        return value == null ? this.nullValue() : this.value((short)value);
    }

    public XContentBuilder value(short value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, String value) throws IOException {
        if (value == null) {
            return this.nullField(name);
        }
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeStringField(name, value);
        return this;
    }

    public XContentBuilder array(String name, String ... values) throws IOException {
        return this.field(name).values(values);
    }

    private XContentBuilder values(String[] values) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        this.startArray();
        for (String s : values) {
            this.value(s);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeString(value);
        return this;
    }

    public XContentBuilder field(String name, byte[] value) throws IOException {
        if (value == null) {
            return this.nullField(name);
        }
        XContentBuilder.ensureNameNotNull(name);
        this.generator.writeBinaryField(name, value);
        return this;
    }

    public XContentBuilder value(byte[] value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value);
        return this;
    }

    public XContentBuilder field(String name, byte[] value, int offset, int length) throws IOException {
        return this.field(name).value(value, offset, length);
    }

    public XContentBuilder value(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value, offset, length);
        return this;
    }

    public XContentBuilder utf8Value(byte[] bytes, int offset, int length) throws IOException {
        this.generator.writeUTF8String(bytes, offset, length);
        return this;
    }

    public XContentBuilder timeField(String name, Object timeValue) throws IOException {
        return this.field(name).timeValue(timeValue);
    }

    public XContentBuilder timeField(String name, String readableName, long value) throws IOException {
        if (this.humanReadable) {
            Function<Object, Object> longTransformer = DATE_TRANSFORMERS.get(Long.class);
            if (longTransformer == null) {
                throw new IllegalArgumentException("cannot write time value xcontent for unknown value of type Long");
            }
            this.field(readableName).value(longTransformer.apply(value));
        }
        this.field(name, value);
        return this;
    }

    public XContentBuilder timeValue(Object timeValue) throws IOException {
        if (timeValue == null) {
            return this.nullValue();
        }
        Function<Object, Object> transformer = DATE_TRANSFORMERS.get(timeValue.getClass());
        if (transformer == null) {
            throw new IllegalArgumentException("cannot write time value xcontent for unknown value of type " + timeValue.getClass());
        }
        return this.value(transformer.apply(timeValue));
    }

    public XContentBuilder latlon(String name, double lat, double lon) throws IOException {
        return this.field(name).latlon(lat, lon);
    }

    public XContentBuilder latlon(double lat, double lon) throws IOException {
        return this.startObject().field("lat", lat).field("lon", lon).endObject();
    }

    public XContentBuilder value(Path value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value(value.toString());
    }

    public XContentBuilder field(String name, Object value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder array(String name, Object ... values) throws IOException {
        return this.field(name).values(values, true);
    }

    private XContentBuilder values(Object[] values, boolean ensureNoSelfReferences) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        return this.value(Arrays.asList(values), ensureNoSelfReferences);
    }

    public XContentBuilder value(Object value) throws IOException {
        this.unknownValue(value, true);
        return this;
    }

    private void unknownValue(Object value, boolean ensureNoSelfReferences) throws IOException {
        if (value == null) {
            this.nullValue();
            return;
        }
        Writer writer = WRITERS.get(value.getClass());
        if (writer != null) {
            writer.write(this, value);
        } else if (value instanceof Path) {
            this.value((Path)value);
        } else if (value instanceof Map) {
            Map valueMap = (Map)value;
            this.map(valueMap, ensureNoSelfReferences);
        } else if (value instanceof Iterable) {
            this.value((Iterable)value, ensureNoSelfReferences);
        } else if (value instanceof Object[]) {
            this.values((Object[])value, ensureNoSelfReferences);
        } else if (value instanceof ToXContent) {
            this.value((ToXContent)value);
        } else if (value instanceof Enum) {
            this.value(Objects.toString(value));
        } else {
            throw new IllegalArgumentException("cannot write xcontent for unknown value of type " + value.getClass());
        }
    }

    public XContentBuilder field(String name, ToXContent value) throws IOException {
        return this.field(name).value(value);
    }

    public XContentBuilder field(String name, ToXContent value, ToXContent.Params params) throws IOException {
        return this.field(name).value(value, params);
    }

    private XContentBuilder value(ToXContent value) throws IOException {
        return this.value(value, ToXContent.EMPTY_PARAMS);
    }

    private XContentBuilder value(ToXContent value, ToXContent.Params params) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        value.toXContent(this, params);
        return this;
    }

    public XContentBuilder field(String name, Map<String, Object> values) throws IOException {
        return this.field(name).map(values);
    }

    public XContentBuilder map(Map<String, ?> values) throws IOException {
        return this.map(values, true);
    }

    private XContentBuilder map(Map<String, ?> values, boolean ensureNoSelfReferences) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        if (ensureNoSelfReferences) {
            XContentBuilder.ensureNoSelfReferences(values);
        }
        this.startObject();
        for (Map.Entry<String, ?> value : values.entrySet()) {
            this.field(value.getKey());
            this.unknownValue(value.getValue(), false);
        }
        this.endObject();
        return this;
    }

    public XContentBuilder field(String name, Iterable<?> values) throws IOException {
        return this.field(name).value(values);
    }

    private XContentBuilder value(Iterable<?> values, boolean ensureNoSelfReferences) throws IOException {
        if (values == null) {
            return this.nullValue();
        }
        if (values instanceof Path) {
            this.value((Path)values);
        } else {
            if (ensureNoSelfReferences) {
                XContentBuilder.ensureNoSelfReferences(values);
            }
            this.startArray();
            for (Object value : values) {
                this.unknownValue(value, false);
            }
            this.endArray();
        }
        return this;
    }

    public XContentBuilder humanReadableField(String rawFieldName, String readableFieldName, Object value) throws IOException {
        HumanReadableTransformer transformer;
        if (this.humanReadable) {
            this.field(readableFieldName, Objects.toString(value));
        }
        if ((transformer = HUMAN_READABLE_TRANSFORMERS.get(value.getClass())) == null) {
            throw new IllegalArgumentException("no raw transformer found for class " + value.getClass());
        }
        Object rawValue = transformer.rawValue(value);
        this.field(rawFieldName, rawValue);
        return this;
    }

    public XContentBuilder percentageField(String rawFieldName, String readableFieldName, double percentage) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, String.format(Locale.ROOT, "%1.1f%%", percentage));
        }
        this.field(rawFieldName, percentage);
        return this;
    }

    @Deprecated
    public XContentBuilder rawField(String name, InputStream value) throws IOException {
        this.generator.writeRawField(name, value);
        return this;
    }

    public XContentBuilder rawField(String name, InputStream value, XContentType contentType) throws IOException {
        this.generator.writeRawField(name, value, contentType);
        return this;
    }

    public XContentBuilder rawValue(InputStream stream, XContentType contentType) throws IOException {
        this.generator.writeRawValue(stream, contentType);
        return this;
    }

    public XContentBuilder copyCurrentStructure(XContentParser parser) throws IOException {
        this.generator.copyCurrentStructure(parser);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to close the XContentBuilder", e);
        }
    }

    public XContentGenerator generator() {
        return this.generator;
    }

    static void ensureNameNotNull(String name) {
        XContentBuilder.ensureNotNull(name, "Field name cannot be null");
    }

    static void ensureNotNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void ensureNoSelfReferences(Object value) {
        Iterable<?> it = XContentBuilder.convert(value);
        if (it != null) {
            XContentBuilder.ensureNoSelfReferences(it, value, Collections.newSetFromMap(new IdentityHashMap()));
        }
    }

    private static Iterable<?> convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return ((Map)value).values();
        }
        if (value instanceof Iterable && !(value instanceof Path)) {
            return (Iterable)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        return null;
    }

    private static void ensureNoSelfReferences(Iterable<?> value, Object originalReference, Set<Object> ancestors) {
        if (value != null) {
            if (!ancestors.add(originalReference)) {
                throw new IllegalArgumentException("Iterable object is self-referencing itself");
            }
            for (Object o : value) {
                XContentBuilder.ensureNoSelfReferences(XContentBuilder.convert(o), o, ancestors);
            }
            ancestors.remove(originalReference);
        }
    }

    static {
        HashMap writers = new HashMap();
        writers.put(Boolean.class, (b, v) -> b.value((Boolean)v));
        writers.put(Byte.class, (b, v) -> b.value((Byte)v));
        writers.put(byte[].class, (b, v) -> b.value((byte[])v));
        writers.put(Date.class, XContentBuilder::timeValue);
        writers.put(Double.class, (b, v) -> b.value((Double)v));
        writers.put(double[].class, (b, v) -> b.values((double[])v));
        writers.put(Float.class, (b, v) -> b.value((Float)v));
        writers.put(float[].class, (b, v) -> b.values((float[])v));
        writers.put(Integer.class, (b, v) -> b.value((Integer)v));
        writers.put(int[].class, (b, v) -> b.values((int[])v));
        writers.put(Long.class, (b, v) -> b.value((Long)v));
        writers.put(long[].class, (b, v) -> b.values((long[])v));
        writers.put(Short.class, (b, v) -> b.value((Short)v));
        writers.put(short[].class, (b, v) -> b.values((short[])v));
        writers.put(String.class, (b, v) -> b.value((String)v));
        writers.put(String[].class, (b, v) -> b.values((String[])v));
        writers.put(Locale.class, (b, v) -> b.value(v.toString()));
        writers.put(Class.class, (b, v) -> b.value(v.toString()));
        writers.put(ZonedDateTime.class, (b, v) -> b.value(v.toString()));
        writers.put(Calendar.class, XContentBuilder::timeValue);
        writers.put(GregorianCalendar.class, XContentBuilder::timeValue);
        HashMap humanReadableTransformer = new HashMap();
        HashMap dateTransformers = new HashMap();
        dateTransformers.put(String.class, Function.identity());
        for (XContentBuilderExtension service : ServiceLoader.load(XContentBuilderExtension.class)) {
            Map<Class<?>, Writer> addlWriters = service.getXContentWriters();
            Map<Class<?>, HumanReadableTransformer> addlTransformers = service.getXContentHumanReadableTransformers();
            Map<Class<?>, Function<Object, Object>> addlDateTransformers = service.getDateTransformers();
            addlWriters.forEach((key, value) -> Objects.requireNonNull(value, "invalid null xcontent writer for class " + key));
            addlTransformers.forEach((key, value) -> Objects.requireNonNull(value, "invalid null xcontent transformer for human readable class " + key));
            dateTransformers.forEach((key, value) -> Objects.requireNonNull(value, "invalid null xcontent date transformer for class " + key));
            writers.putAll(addlWriters);
            humanReadableTransformer.putAll(addlTransformers);
            dateTransformers.putAll(addlDateTransformers);
        }
        WRITERS = Collections.unmodifiableMap(writers);
        HUMAN_READABLE_TRANSFORMERS = Collections.unmodifiableMap(humanReadableTransformer);
        DATE_TRANSFORMERS = Collections.unmodifiableMap(dateTransformers);
    }

    @FunctionalInterface
    public static interface HumanReadableTransformer {
        public Object rawValue(Object var1) throws IOException;
    }

    @FunctionalInterface
    public static interface Writer {
        public void write(XContentBuilder var1, Object var2) throws IOException;
    }
}

