/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.AbstractProcessor;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.ConfigurationException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.ContextualCallable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Initializer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.InjectorImpl;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.SingleMemberInjector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.internal.Errors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.internal.ErrorsException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.internal.InternalContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.spi.InjectionRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.spi.StaticInjectionRequest;

class InjectionRequestProcessor
extends AbstractProcessor {
    private final List<StaticInjection> staticInjections = new ArrayList<StaticInjection>();
    private final Initializer initializer;

    InjectionRequestProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public Boolean visit(StaticInjectionRequest request) {
        this.staticInjections.add(new StaticInjection(this.injector, request));
        return true;
    }

    @Override
    public Boolean visit(InjectionRequest request) {
        Set injectionPoints;
        try {
            injectionPoints = request.getInjectionPoints();
        }
        catch (ConfigurationException e) {
            this.errors.merge(e.getErrorMessages());
            injectionPoints = (Set)e.getPartialValue();
        }
        this.initializer.requestInjection(this.injector, request.getInstance(), request.getSource(), injectionPoints);
        return true;
    }

    public void validate() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.validate();
        }
    }

    public void injectMembers() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.injectMembers();
        }
    }

    private class StaticInjection {
        final InjectorImpl injector;
        final Object source;
        final StaticInjectionRequest request;
        List<SingleMemberInjector> memberInjectors;

        StaticInjection(InjectorImpl injector, StaticInjectionRequest request) {
            this.injector = injector;
            this.source = request.getSource();
            this.request = request;
        }

        void validate() {
            Set injectionPoints;
            Errors errorsForMember = InjectionRequestProcessor.this.errors.withSource(this.source);
            try {
                injectionPoints = this.request.getInjectionPoints();
            }
            catch (ConfigurationException e) {
                InjectionRequestProcessor.this.errors.merge(e.getErrorMessages());
                injectionPoints = (Set)e.getPartialValue();
            }
            this.memberInjectors = this.injector.membersInjectorStore.getInjectors(injectionPoints, errorsForMember);
        }

        void injectMembers() {
            try {
                this.injector.callInContext(new ContextualCallable<Void>(){

                    @Override
                    public Void call(InternalContext context) {
                        for (SingleMemberInjector injector : StaticInjection.this.memberInjectors) {
                            injector.inject(InjectionRequestProcessor.this.errors, context, null);
                        }
                        return null;
                    }
                });
            }
            catch (ErrorsException e) {
                throw new AssertionError();
            }
        }
    }
}

