/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.geo.Rectangle;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.SloppyMath;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo.GeoDistance;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.DistanceUnit;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.FieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.GeoPointValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortingNumericDoubleValues;

public class GeoUtils {
    public static final double MAX_LAT = 90.0;
    public static final double MIN_LAT = -90.0;
    public static final double MAX_LON = 180.0;
    public static final double MIN_LON = -180.0;
    public static final String LATITUDE = "lat";
    public static final String LONGITUDE = "lon";
    public static final String GEOHASH = "geohash";
    public static final double EARTH_SEMI_MAJOR_AXIS = 6378137.0;
    public static final double EARTH_SEMI_MINOR_AXIS = 6356752.314245;
    public static final double EARTH_MEAN_RADIUS = 6371008.7714;
    public static final double EARTH_AXIS_RATIO = 0.9966471893352243;
    public static final double EARTH_EQUATOR = 4.007501668557849E7;
    public static final double EARTH_POLAR_DISTANCE = 1.9970326371122006E7;
    public static final double TOLERANCE = 1.0E-6;

    public static boolean isValidLatitude(double latitude) {
        return !Double.isNaN(latitude) && !Double.isInfinite(latitude) && !(latitude < -90.0) && !(latitude > 90.0);
    }

    public static boolean isValidLongitude(double longitude) {
        return !Double.isNaN(longitude) && !Double.isInfinite(longitude) && !(longitude < -180.0) && !(longitude > 180.0);
    }

    public static double geoHashCellWidth(int level) {
        assert (level >= 0);
        return 4.007501668557849E7 / (double)(1L << (level + 1) / 2 * 3 + level / 2 * 2);
    }

    public static double quadTreeCellWidth(int level) {
        assert (level >= 0);
        return 4.007501668557849E7 / (double)(1L << level);
    }

    public static double geoHashCellHeight(int level) {
        assert (level >= 0);
        return 1.9970326371122006E7 / (double)(1L << (level + 1) / 2 * 2 + level / 2 * 3);
    }

    public static double quadTreeCellHeight(int level) {
        assert (level >= 0);
        return 1.9970326371122006E7 / (double)(1L << level);
    }

    public static double geoHashCellSize(int level) {
        assert (level >= 0);
        double w = GeoUtils.geoHashCellWidth(level);
        double h = GeoUtils.geoHashCellHeight(level);
        return Math.sqrt(w * w + h * h);
    }

    public static double quadTreeCellSize(int level) {
        assert (level >= 0);
        return Math.sqrt(2.0048208977185252E15) / (double)(1L << level);
    }

    public static int quadTreeLevelsForPrecision(double meters) {
        int level;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return 50;
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        long part = Math.round(Math.ceil(4.007501668557849E7 / width));
        return part <= 1L << (level = 64 - Long.numberOfLeadingZeros(part) - 1) ? level : level + 1;
    }

    public static int quadTreeLevelsForPrecision(String distance) {
        return GeoUtils.quadTreeLevelsForPrecision(DistanceUnit.METERS.parse(distance, DistanceUnit.DEFAULT));
    }

    public static int geoHashLevelsForPrecision(double meters) {
        int full;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return GeohashPrefixTree.getMaxLevelsPossible();
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        double part = Math.ceil(4.007501668557849E7 / width);
        if (part == 1.0) {
            return 1;
        }
        int bits = (int)Math.round(Math.ceil(Math.log(part) / Math.log(2.0)));
        int left = bits - (full = bits / 5) * 5;
        int even = full + (left > 0 ? 1 : 0);
        int odd = full + (left > 3 ? 1 : 0);
        return even + odd;
    }

    public static int geoHashLevelsForPrecision(String distance) {
        return GeoUtils.geoHashLevelsForPrecision(DistanceUnit.METERS.parse(distance, DistanceUnit.DEFAULT));
    }

    public static double normalizeLon(double lon) {
        return GeoUtils.centeredModulus(lon, 360.0);
    }

    public static double normalizeLat(double lat) {
        if ((lat = GeoUtils.centeredModulus(lat, 360.0)) < -90.0) {
            lat = -180.0 - lat;
        } else if (lat > 90.0) {
            lat = 180.0 - lat;
        }
        return lat;
    }

    public static void normalizePoint(GeoPoint point) {
        GeoUtils.normalizePoint(point, true, true);
    }

    public static void normalizePoint(GeoPoint point, boolean normLat, boolean normLon) {
        double[] pt = new double[]{point.lon(), point.lat()};
        GeoUtils.normalizePoint(pt, normLon, normLat);
        point.reset(pt[1], pt[0]);
    }

    public static void normalizePoint(double[] lonLat) {
        GeoUtils.normalizePoint(lonLat, true, true);
    }

    public static void normalizePoint(double[] lonLat, boolean normLon, boolean normLat) {
        assert (lonLat != null && lonLat.length == 2);
        normLat = normLat && (lonLat[1] > 90.0 || lonLat[1] < -90.0);
        boolean bl = normLon = normLon && (lonLat[0] > 180.0 || lonLat[0] < -180.0);
        if (normLat) {
            lonLat[1] = GeoUtils.centeredModulus(lonLat[1], 360.0);
            boolean shift = true;
            if (lonLat[1] < -90.0) {
                lonLat[1] = -180.0 - lonLat[1];
            } else if (lonLat[1] > 90.0) {
                lonLat[1] = 180.0 - lonLat[1];
            } else {
                shift = false;
            }
            if (shift) {
                lonLat[0] = normLon ? lonLat[0] + 180.0 : lonLat[0] + (GeoUtils.normalizeLon(lonLat[0]) > 0.0 ? -180.0 : 180.0);
            }
        }
        if (normLon) {
            lonLat[0] = GeoUtils.centeredModulus(lonLat[0], 360.0);
        }
    }

    private static double centeredModulus(double dividend, double divisor) {
        double rtn = dividend % divisor;
        if (rtn <= 0.0) {
            rtn += divisor;
        }
        if (rtn > divisor / 2.0) {
            rtn -= divisor;
        }
        return rtn;
    }

    public static GeoPoint parseGeoPoint(XContentParser parser) throws IOException, ElasticsearchParseException {
        return GeoUtils.parseGeoPoint(parser, new GeoPoint());
    }

    public static GeoPoint parseGeoPoint(XContentParser parser, GeoPoint point) throws IOException, ElasticsearchParseException {
        return GeoUtils.parseGeoPoint(parser, point, false);
    }

    /*
     * Exception decompiling
     */
    public static GeoPoint parseGeoPoint(Object value, boolean ignoreZValue) throws ElasticsearchParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static GeoPoint parseGeoPoint(XContentParser parser, GeoPoint point, boolean ignoreZValue) throws IOException, ElasticsearchParseException {
        double lat = Double.NaN;
        double lon = Double.NaN;
        String geohash = null;
        NumberFormatException numberFormatException = null;
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                    String field = parser.currentName();
                    if (LATITUDE.equals(field)) {
                        parser.nextToken();
                        switch (parser.currentToken()) {
                            case VALUE_NUMBER: 
                            case VALUE_STRING: {
                                try {
                                    lat = parser.doubleValue(true);
                                }
                                catch (NumberFormatException e) {
                                    numberFormatException = e;
                                }
                                continue block10;
                            }
                        }
                        throw new ElasticsearchParseException("latitude must be a number", new Object[0]);
                    }
                    if (LONGITUDE.equals(field)) {
                        parser.nextToken();
                        switch (parser.currentToken()) {
                            case VALUE_NUMBER: 
                            case VALUE_STRING: {
                                try {
                                    lon = parser.doubleValue(true);
                                }
                                catch (NumberFormatException e) {
                                    numberFormatException = e;
                                }
                                continue block10;
                            }
                        }
                        throw new ElasticsearchParseException("longitude must be a number", new Object[0]);
                    }
                    if (GEOHASH.equals(field)) {
                        if (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
                            geohash = parser.text();
                            continue;
                        }
                        throw new ElasticsearchParseException("geohash must be a string", new Object[0]);
                    }
                    throw new ElasticsearchParseException("field must be either [{}], [{}] or [{}]", LATITUDE, LONGITUDE, GEOHASH);
                }
                throw new ElasticsearchParseException("token [{}] not allowed", new Object[]{parser.currentToken()});
            }
            if (geohash != null) {
                if (!Double.isNaN(lat) || !Double.isNaN(lon)) {
                    throw new ElasticsearchParseException("field must be either lat/lon or geohash", new Object[0]);
                }
                return point.resetFromGeoHash(geohash);
            }
            if (numberFormatException != null) {
                throw new ElasticsearchParseException("[{}] and [{}] must be valid double values", numberFormatException, LATITUDE, LONGITUDE);
            }
            if (Double.isNaN(lat)) {
                throw new ElasticsearchParseException("field [{}] missing", LATITUDE);
            }
            if (Double.isNaN(lon)) {
                throw new ElasticsearchParseException("field [{}] missing", LONGITUDE);
            }
            return point.reset(lat, lon);
        }
        if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            int element = 0;
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    if (++element == 1) {
                        lon = parser.doubleValue();
                        continue;
                    }
                    if (element == 2) {
                        lat = parser.doubleValue();
                        continue;
                    }
                    GeoPoint.assertZValue(ignoreZValue, parser.doubleValue());
                    continue;
                }
                throw new ElasticsearchParseException("numeric value expected", new Object[0]);
            }
            return point.reset(lat, lon);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return point.resetFromString(parser.text(), ignoreZValue);
        }
        throw new ElasticsearchParseException("geo_point expected", new Object[0]);
    }

    public static int parsePrecision(XContentParser parser) throws IOException, ElasticsearchParseException {
        XContentParser.Token token = parser.currentToken();
        if (token.equals((Object)XContentParser.Token.VALUE_NUMBER)) {
            return XContentMapValues.nodeIntegerValue(parser.intValue());
        }
        String precision = parser.text();
        try {
            return XContentMapValues.nodeIntegerValue(precision);
        }
        catch (NumberFormatException e) {
            int parsedPrecision = GeoUtils.geoHashLevelsForPrecision(precision);
            try {
                return GeoUtils.checkPrecisionRange(parsedPrecision);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("precision too high [" + precision + "]", e2);
            }
        }
    }

    public static int checkPrecisionRange(int precision) {
        if (precision < 1 || precision > 12) {
            throw new IllegalArgumentException("Invalid geohash aggregation precision of " + precision + ". Must be between 1 and 12.");
        }
        return precision;
    }

    public static double maxRadialDistanceMeters(double centerLat, double centerLon) {
        if (Math.abs(centerLat) == 90.0) {
            return SloppyMath.haversinMeters(centerLat, centerLon, 0.0, centerLon);
        }
        return SloppyMath.haversinMeters(centerLat, centerLon, centerLat, (180.0 + centerLon) % 360.0);
    }

    public static double arcDistance(double lat1, double lon1, double lat2, double lon2) {
        return SloppyMath.haversinMeters(lat1, lon1, lat2, lon2);
    }

    public static double planeDistance(double lat1, double lon1, double lat2, double lon2) {
        double x = (lon2 - lon1) * (Math.PI / 180) * Math.cos((lat2 + lat1) / 2.0 * (Math.PI / 180));
        double y = (lat2 - lat1) * (Math.PI / 180);
        return Math.sqrt(x * x + y * y) * 6371008.7714;
    }

    public static boolean rectangleContainsPoint(Rectangle r, double lat, double lon) {
        if (lat >= r.minLat && lat <= r.maxLat) {
            return r.crossesDateline() ? lon >= r.minLon || lon <= r.maxLon : lon >= r.minLon && lon <= r.maxLon;
        }
        return false;
    }

    public static SortedNumericDoubleValues distanceValues(final GeoDistance distance, final DistanceUnit unit, final MultiGeoPointValues geoPointValues, final GeoPoint ... fromPoints) {
        final GeoPointValues singleValues = FieldData.unwrapSingleton(geoPointValues);
        if (singleValues != null && fromPoints.length == 1) {
            return FieldData.singleton(new NumericDoubleValues(){

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return singleValues.advanceExact(doc);
                }

                @Override
                public double doubleValue() throws IOException {
                    GeoPoint from = fromPoints[0];
                    GeoPoint to = singleValues.geoPointValue();
                    return distance.calculate(from.lat(), from.lon(), to.lat(), to.lon(), unit);
                }
            });
        }
        return new SortingNumericDoubleValues(){

            @Override
            public boolean advanceExact(int target) throws IOException {
                if (geoPointValues.advanceExact(target)) {
                    this.resize(geoPointValues.docValueCount() * fromPoints.length);
                    int v = 0;
                    for (int i = 0; i < geoPointValues.docValueCount(); ++i) {
                        GeoPoint point = geoPointValues.nextValue();
                        for (GeoPoint from : fromPoints) {
                            this.values[v] = distance.calculate(from.lat(), from.lon(), point.lat(), point.lon(), unit);
                            ++v;
                        }
                    }
                    this.sort();
                    return true;
                }
                return false;
            }
        };
    }

    private GeoUtils() {
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

