/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.SourcePrioritizedRunnable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Priority;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;

public abstract class TaskBatcher {
    private final Logger logger;
    private final PrioritizedEsThreadPoolExecutor threadExecutor;
    final Map<Object, LinkedHashSet<BatchedTask>> tasksPerBatchingKey = new HashMap<Object, LinkedHashSet<BatchedTask>>();

    public TaskBatcher(Logger logger, PrioritizedEsThreadPoolExecutor threadExecutor) {
        this.logger = logger;
        this.threadExecutor = threadExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTasks(List<? extends BatchedTask> tasks, @Nullable TimeValue timeout) throws EsRejectedExecutionException {
        if (tasks.isEmpty()) {
            return;
        }
        BatchedTask firstTask = tasks.get(0);
        assert (tasks.stream().allMatch(t -> t.batchingKey == firstTask.batchingKey)) : "tasks submitted in a batch should share the same batching key: " + tasks;
        Map tasksIdentity = tasks.stream().collect(Collectors.toMap(BatchedTask::getTask, Function.identity(), (a, b) -> {
            throw new IllegalStateException("cannot add duplicate task: " + a);
        }, IdentityHashMap::new));
        Map<Object, LinkedHashSet<BatchedTask>> map = this.tasksPerBatchingKey;
        synchronized (map) {
            LinkedHashSet existingTasks = this.tasksPerBatchingKey.computeIfAbsent(firstTask.batchingKey, k -> new LinkedHashSet(tasks.size()));
            for (BatchedTask existing : existingTasks) {
                BatchedTask duplicateTask = (BatchedTask)tasksIdentity.get(existing.getTask());
                if (duplicateTask == null) continue;
                throw new IllegalStateException("task [" + duplicateTask.describeTasks(Collections.singletonList(existing)) + "] with source [" + duplicateTask.source + "] is already queued");
            }
            existingTasks.addAll(tasks);
        }
        if (timeout != null) {
            this.threadExecutor.execute(firstTask, timeout, () -> this.onTimeoutInternal(tasks, timeout));
        } else {
            this.threadExecutor.execute(firstTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimeoutInternal(List<? extends BatchedTask> tasks, TimeValue timeout) {
        ArrayList<BatchedTask> toRemove = new ArrayList<BatchedTask>();
        for (BatchedTask batchedTask : tasks) {
            if (batchedTask.processed.getAndSet(true)) continue;
            this.logger.debug("task [{}] timed out after [{}]", (Object)batchedTask.source, (Object)timeout);
            toRemove.add(batchedTask);
        }
        if (!toRemove.isEmpty()) {
            BatchedTask firstTask = (BatchedTask)toRemove.get(0);
            Object object = firstTask.batchingKey;
            assert (tasks.stream().allMatch(t -> t.batchingKey == batchingKey)) : "tasks submitted in a batch should share the same batching key: " + tasks;
            Map<Object, LinkedHashSet<BatchedTask>> map = this.tasksPerBatchingKey;
            synchronized (map) {
                LinkedHashSet<BatchedTask> existingTasks = this.tasksPerBatchingKey.get(object);
                if (existingTasks != null) {
                    existingTasks.removeAll(toRemove);
                    if (existingTasks.isEmpty()) {
                        this.tasksPerBatchingKey.remove(object);
                    }
                }
            }
            this.onTimeout(toRemove, timeout);
        }
    }

    protected abstract void onTimeout(List<? extends BatchedTask> var1, TimeValue var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runIfNotProcessed(BatchedTask updateTask) {
        if (!updateTask.processed.get()) {
            ArrayList<BatchedTask> toExecute = new ArrayList<BatchedTask>();
            HashMap<String, List> processTasksBySource = new HashMap<String, List>();
            Map<Object, LinkedHashSet<BatchedTask>> map = this.tasksPerBatchingKey;
            synchronized (map) {
                LinkedHashSet<BatchedTask> pending = this.tasksPerBatchingKey.remove(updateTask.batchingKey);
                if (pending != null) {
                    for (BatchedTask task : pending) {
                        if (!task.processed.getAndSet(true)) {
                            this.logger.trace("will process {}", (Object)task);
                            toExecute.add(task);
                            processTasksBySource.computeIfAbsent(task.source, s -> new ArrayList()).add(task);
                            continue;
                        }
                        this.logger.trace("skipping {}, already processed", (Object)task);
                    }
                }
            }
            if (!toExecute.isEmpty()) {
                String tasksSummary = processTasksBySource.entrySet().stream().map(entry -> {
                    String tasks = updateTask.describeTasks((List)entry.getValue());
                    return tasks.isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + "[" + tasks + "]";
                }).reduce((s1, s2) -> s1 + ", " + s2).orElse("");
                this.run(updateTask.batchingKey, toExecute, tasksSummary);
            }
        }
    }

    protected abstract void run(Object var1, List<? extends BatchedTask> var2, String var3);

    protected abstract class BatchedTask
    extends SourcePrioritizedRunnable {
        protected final AtomicBoolean processed;
        protected final Object batchingKey;
        protected final Object task;

        protected BatchedTask(Priority priority, String source, Object batchingKey, Object task) {
            super(priority, source);
            this.processed = new AtomicBoolean();
            this.batchingKey = batchingKey;
            this.task = task;
        }

        @Override
        public void run() {
            TaskBatcher.this.runIfNotProcessed(this);
        }

        @Override
        public String toString() {
            String taskDescription = this.describeTasks(Collections.singletonList(this));
            if (taskDescription.isEmpty()) {
                return "[" + this.source + "]";
            }
            return "[" + this.source + "[" + taskDescription + "]]";
        }

        public abstract String describeTasks(List<? extends BatchedTask> var1);

        public Object getTask() {
            return this.task;
        }
    }
}

